// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DigitalTwins.Models
{
    /// <summary> The CleanupConnectionArtifact. </summary>
    public readonly partial struct CleanupConnectionArtifact : IEquatable<CleanupConnectionArtifact>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CleanupConnectionArtifact"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CleanupConnectionArtifact(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "true";
        private const string FalseValue = "false";

        /// <summary> true. </summary>
        public static CleanupConnectionArtifact True { get; } = new CleanupConnectionArtifact(TrueValue);
        /// <summary> false. </summary>
        public static CleanupConnectionArtifact False { get; } = new CleanupConnectionArtifact(FalseValue);
        /// <summary> Determines if two <see cref="CleanupConnectionArtifact"/> values are the same. </summary>
        public static bool operator ==(CleanupConnectionArtifact left, CleanupConnectionArtifact right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CleanupConnectionArtifact"/> values are not the same. </summary>
        public static bool operator !=(CleanupConnectionArtifact left, CleanupConnectionArtifact right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CleanupConnectionArtifact"/>. </summary>
        public static implicit operator CleanupConnectionArtifact(string value) => new CleanupConnectionArtifact(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CleanupConnectionArtifact other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CleanupConnectionArtifact other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
