// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DigitalTwins
{
    internal class DigitalTwinsPrivateEndpointConnectionOperationSource : IOperationSource<DigitalTwinsPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal DigitalTwinsPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        DigitalTwinsPrivateEndpointConnectionResource IOperationSource<DigitalTwinsPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DigitalTwinsPrivateEndpointConnectionData.DeserializeDigitalTwinsPrivateEndpointConnectionData(document.RootElement);
            return new DigitalTwinsPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<DigitalTwinsPrivateEndpointConnectionResource> IOperationSource<DigitalTwinsPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DigitalTwinsPrivateEndpointConnectionData.DeserializeDigitalTwinsPrivateEndpointConnectionData(document.RootElement);
            return new DigitalTwinsPrivateEndpointConnectionResource(_client, data);
        }
    }
}
