// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DigitalTwins
{
    internal class DigitalTwinsEndpointResourceOperationSource : IOperationSource<DigitalTwinsEndpointResource>
    {
        private readonly ArmClient _client;

        internal DigitalTwinsEndpointResourceOperationSource(ArmClient client)
        {
            _client = client;
        }

        DigitalTwinsEndpointResource IOperationSource<DigitalTwinsEndpointResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DigitalTwinsEndpointResourceData.DeserializeDigitalTwinsEndpointResourceData(document.RootElement);
            return new DigitalTwinsEndpointResource(_client, data);
        }

        async ValueTask<DigitalTwinsEndpointResource> IOperationSource<DigitalTwinsEndpointResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DigitalTwinsEndpointResourceData.DeserializeDigitalTwinsEndpointResourceData(document.RootElement);
            return new DigitalTwinsEndpointResource(_client, data);
        }
    }
}
