// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DigitalTwins
{
    internal class DigitalTwinsDescriptionOperationSource : IOperationSource<DigitalTwinsDescriptionResource>
    {
        private readonly ArmClient _client;

        internal DigitalTwinsDescriptionOperationSource(ArmClient client)
        {
            _client = client;
        }

        DigitalTwinsDescriptionResource IOperationSource<DigitalTwinsDescriptionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DigitalTwinsDescriptionData.DeserializeDigitalTwinsDescriptionData(document.RootElement);
            return new DigitalTwinsDescriptionResource(_client, data);
        }

        async ValueTask<DigitalTwinsDescriptionResource> IOperationSource<DigitalTwinsDescriptionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DigitalTwinsDescriptionData.DeserializeDigitalTwinsDescriptionData(document.RootElement);
            return new DigitalTwinsDescriptionResource(_client, data);
        }
    }
}
