// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.DigitalTwins.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableDigitalTwinsArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDigitalTwinsArmClient"/> class for mocking. </summary>
        protected MockableDigitalTwinsArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDigitalTwinsArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDigitalTwinsArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableDigitalTwinsArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="DigitalTwinsDescriptionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DigitalTwinsDescriptionResource.CreateResourceIdentifier" /> to create a <see cref="DigitalTwinsDescriptionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DigitalTwinsDescriptionResource"/> object. </returns>
        public virtual DigitalTwinsDescriptionResource GetDigitalTwinsDescriptionResource(ResourceIdentifier id)
        {
            DigitalTwinsDescriptionResource.ValidateResourceId(id);
            return new DigitalTwinsDescriptionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DigitalTwinsEndpointResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DigitalTwinsEndpointResource.CreateResourceIdentifier" /> to create a <see cref="DigitalTwinsEndpointResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DigitalTwinsEndpointResource"/> object. </returns>
        public virtual DigitalTwinsEndpointResource GetDigitalTwinsEndpointResource(ResourceIdentifier id)
        {
            DigitalTwinsEndpointResource.ValidateResourceId(id);
            return new DigitalTwinsEndpointResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DigitalTwinsPrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DigitalTwinsPrivateLinkResource.CreateResourceIdentifier" /> to create a <see cref="DigitalTwinsPrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DigitalTwinsPrivateLinkResource"/> object. </returns>
        public virtual DigitalTwinsPrivateLinkResource GetDigitalTwinsPrivateLinkResource(ResourceIdentifier id)
        {
            DigitalTwinsPrivateLinkResource.ValidateResourceId(id);
            return new DigitalTwinsPrivateLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DigitalTwinsPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DigitalTwinsPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="DigitalTwinsPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DigitalTwinsPrivateEndpointConnectionResource"/> object. </returns>
        public virtual DigitalTwinsPrivateEndpointConnectionResource GetDigitalTwinsPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            DigitalTwinsPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new DigitalTwinsPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="TimeSeriesDatabaseConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="TimeSeriesDatabaseConnectionResource.CreateResourceIdentifier" /> to create a <see cref="TimeSeriesDatabaseConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="TimeSeriesDatabaseConnectionResource"/> object. </returns>
        public virtual TimeSeriesDatabaseConnectionResource GetTimeSeriesDatabaseConnectionResource(ResourceIdentifier id)
        {
            TimeSeriesDatabaseConnectionResource.ValidateResourceId(id);
            return new TimeSeriesDatabaseConnectionResource(Client, id);
        }
    }
}
