// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DigitalTwins.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DigitalTwins
{
    /// <summary>
    /// A class representing the DigitalTwinsDescription data model.
    /// The description of the DigitalTwins service.
    /// </summary>
    public partial class DigitalTwinsDescriptionData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DigitalTwinsDescriptionData"/>. </summary>
        /// <param name="location"> The location. </param>
        public DigitalTwinsDescriptionData(AzureLocation location) : base(location)
        {
            PrivateEndpointConnections = new ChangeTrackingList<DigitalTwinsPrivateEndpointConnectionData>();
        }

        /// <summary> Initializes a new instance of <see cref="DigitalTwinsDescriptionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="createdOn"> Time when DigitalTwinsInstance was created. </param>
        /// <param name="lastUpdatedOn"> Time when DigitalTwinsInstance was updated. </param>
        /// <param name="provisioningState"> The provisioning state. </param>
        /// <param name="hostName"> Api endpoint to work with DigitalTwinsInstance. </param>
        /// <param name="privateEndpointConnections"> The private endpoint connections. </param>
        /// <param name="publicNetworkAccess"> Public network access for the DigitalTwinsInstance. </param>
        /// <param name="identity"> The managed identity for the DigitalTwinsInstance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DigitalTwinsDescriptionData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, DateTimeOffset? createdOn, DateTimeOffset? lastUpdatedOn, DigitalTwinsProvisioningState? provisioningState, string hostName, IList<DigitalTwinsPrivateEndpointConnectionData> privateEndpointConnections, DigitalTwinsPublicNetworkAccess? publicNetworkAccess, ManagedServiceIdentity identity, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            CreatedOn = createdOn;
            LastUpdatedOn = lastUpdatedOn;
            ProvisioningState = provisioningState;
            HostName = hostName;
            PrivateEndpointConnections = privateEndpointConnections;
            PublicNetworkAccess = publicNetworkAccess;
            Identity = identity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DigitalTwinsDescriptionData"/> for deserialization. </summary>
        internal DigitalTwinsDescriptionData()
        {
        }

        /// <summary> Time when DigitalTwinsInstance was created. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Time when DigitalTwinsInstance was updated. </summary>
        public DateTimeOffset? LastUpdatedOn { get; }
        /// <summary> The provisioning state. </summary>
        public DigitalTwinsProvisioningState? ProvisioningState { get; }
        /// <summary> Api endpoint to work with DigitalTwinsInstance. </summary>
        public string HostName { get; }
        /// <summary> The private endpoint connections. </summary>
        public IList<DigitalTwinsPrivateEndpointConnectionData> PrivateEndpointConnections { get; set; }
        /// <summary> Public network access for the DigitalTwinsInstance. </summary>
        public DigitalTwinsPublicNetworkAccess? PublicNetworkAccess { get; set; }
        /// <summary> The managed identity for the DigitalTwinsInstance. </summary>
        public ManagedServiceIdentity Identity { get; set; }
    }
}
