// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DigitalTwins.Models;

namespace Azure.ResourceManager.DigitalTwins.Samples
{
    public partial class Sample_TimeSeriesDatabaseConnectionResource
    {
        // Get time series database connection for a DigitalTwins instance.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetTimeSeriesDatabaseConnectionForADigitalTwinsInstance()
        {
            // Generated from example definition: specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/TimeSeriesDatabaseConnectionsGet_example.json
            // this example is just showing the usage of "TimeSeriesDatabaseConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TimeSeriesDatabaseConnectionResource created on azure
            // for more information of creating TimeSeriesDatabaseConnectionResource, please refer to the document of TimeSeriesDatabaseConnectionResource
            string subscriptionId = "50016170-c839-41ba-a724-51e9df440b9e";
            string resourceGroupName = "resRg";
            string resourceName = "myDigitalTwinsService";
            string timeSeriesDatabaseConnectionName = "myConnection";
            ResourceIdentifier timeSeriesDatabaseConnectionResourceId = TimeSeriesDatabaseConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, timeSeriesDatabaseConnectionName);
            TimeSeriesDatabaseConnectionResource timeSeriesDatabaseConnection = client.GetTimeSeriesDatabaseConnectionResource(timeSeriesDatabaseConnectionResourceId);

            // invoke the operation
            TimeSeriesDatabaseConnectionResource result = await timeSeriesDatabaseConnection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TimeSeriesDatabaseConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or replace a time series database connection for a DigitalTwins instance with user assigned identity.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrReplaceATimeSeriesDatabaseConnectionForADigitalTwinsInstanceWithUserAssignedIdentity()
        {
            // Generated from example definition: specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/TimeSeriesDatabaseConnectionsPut_WithUserIdentity_example.json
            // this example is just showing the usage of "TimeSeriesDatabaseConnections_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TimeSeriesDatabaseConnectionResource created on azure
            // for more information of creating TimeSeriesDatabaseConnectionResource, please refer to the document of TimeSeriesDatabaseConnectionResource
            string subscriptionId = "50016170-c839-41ba-a724-51e9df440b9e";
            string resourceGroupName = "resRg";
            string resourceName = "myDigitalTwinsService";
            string timeSeriesDatabaseConnectionName = "myConnection";
            ResourceIdentifier timeSeriesDatabaseConnectionResourceId = TimeSeriesDatabaseConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, timeSeriesDatabaseConnectionName);
            TimeSeriesDatabaseConnectionResource timeSeriesDatabaseConnection = client.GetTimeSeriesDatabaseConnectionResource(timeSeriesDatabaseConnectionResourceId);

            // invoke the operation
            TimeSeriesDatabaseConnectionData data = new TimeSeriesDatabaseConnectionData()
            {
                Properties = new DataExplorerConnectionProperties(new ResourceIdentifier("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"), new Uri("https://mycluster.kusto.windows.net"), "myDatabase", new Uri("sb://myeh.servicebus.windows.net/"), "myeh", new ResourceIdentifier("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"))
                {
                    AdxTableName = "myTable",
                    Identity = new DigitalTwinsManagedIdentityReference()
                    {
                        IdentityType = DigitalTwinsManagedIdentityType.UserAssigned,
                        UserAssignedIdentity = "/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity",
                    },
                },
            };
            ArmOperation<TimeSeriesDatabaseConnectionResource> lro = await timeSeriesDatabaseConnection.UpdateAsync(WaitUntil.Completed, data);
            TimeSeriesDatabaseConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TimeSeriesDatabaseConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or replace a time series database connection for a DigitalTwins instance.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrReplaceATimeSeriesDatabaseConnectionForADigitalTwinsInstance()
        {
            // Generated from example definition: specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/TimeSeriesDatabaseConnectionsPut_example.json
            // this example is just showing the usage of "TimeSeriesDatabaseConnections_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TimeSeriesDatabaseConnectionResource created on azure
            // for more information of creating TimeSeriesDatabaseConnectionResource, please refer to the document of TimeSeriesDatabaseConnectionResource
            string subscriptionId = "50016170-c839-41ba-a724-51e9df440b9e";
            string resourceGroupName = "resRg";
            string resourceName = "myDigitalTwinsService";
            string timeSeriesDatabaseConnectionName = "myConnection";
            ResourceIdentifier timeSeriesDatabaseConnectionResourceId = TimeSeriesDatabaseConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, timeSeriesDatabaseConnectionName);
            TimeSeriesDatabaseConnectionResource timeSeriesDatabaseConnection = client.GetTimeSeriesDatabaseConnectionResource(timeSeriesDatabaseConnectionResourceId);

            // invoke the operation
            TimeSeriesDatabaseConnectionData data = new TimeSeriesDatabaseConnectionData()
            {
                Properties = new DataExplorerConnectionProperties(new ResourceIdentifier("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.Kusto/clusters/mycluster"), new Uri("https://mycluster.kusto.windows.net"), "myDatabase", new Uri("sb://myeh.servicebus.windows.net/"), "myeh", new ResourceIdentifier("/subscriptions/c493073e-2460-45ba-a403-f3e0df1e9feg/resourceGroups/testrg/providers/Microsoft.EventHub/namespaces/myeh"))
                {
                    AdxTableName = "myPropertyUpdatesTable",
                    AdxTwinLifecycleEventsTableName = "myTwinLifecycleEventsTable",
                    AdxRelationshipLifecycleEventsTableName = "myRelationshipLifecycleEventsTable",
                    RecordPropertyAndItemRemovals = RecordPropertyAndItemRemoval.True,
                },
            };
            ArmOperation<TimeSeriesDatabaseConnectionResource> lro = await timeSeriesDatabaseConnection.UpdateAsync(WaitUntil.Completed, data);
            TimeSeriesDatabaseConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TimeSeriesDatabaseConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a time series database connection for a DigitalTwins instance.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteATimeSeriesDatabaseConnectionForADigitalTwinsInstance()
        {
            // Generated from example definition: specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/TimeSeriesDatabaseConnectionsDelete_example.json
            // this example is just showing the usage of "TimeSeriesDatabaseConnections_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TimeSeriesDatabaseConnectionResource created on azure
            // for more information of creating TimeSeriesDatabaseConnectionResource, please refer to the document of TimeSeriesDatabaseConnectionResource
            string subscriptionId = "50016170-c839-41ba-a724-51e9df440b9e";
            string resourceGroupName = "resRg";
            string resourceName = "myDigitalTwinsService";
            string timeSeriesDatabaseConnectionName = "myConnection";
            ResourceIdentifier timeSeriesDatabaseConnectionResourceId = TimeSeriesDatabaseConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, timeSeriesDatabaseConnectionName);
            TimeSeriesDatabaseConnectionResource timeSeriesDatabaseConnection = client.GetTimeSeriesDatabaseConnectionResource(timeSeriesDatabaseConnectionResourceId);

            // invoke the operation
            ArmOperation<TimeSeriesDatabaseConnectionResource> lro = await timeSeriesDatabaseConnection.DeleteAsync(WaitUntil.Completed);
            TimeSeriesDatabaseConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TimeSeriesDatabaseConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
