// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.DigitalTwins.Samples
{
    public partial class Sample_DigitalTwinsPrivateLinkResource
    {
        // Get the specified private link resource for the given Digital Twin
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetTheSpecifiedPrivateLinkResourceForTheGivenDigitalTwin()
        {
            // Generated from example definition: specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/PrivateLinkResourcesByGroupId_example.json
            // this example is just showing the usage of "PrivateLinkResources_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DigitalTwinsPrivateLinkResource created on azure
            // for more information of creating DigitalTwinsPrivateLinkResource, please refer to the document of DigitalTwinsPrivateLinkResource
            string subscriptionId = "50016170-c839-41ba-a724-51e9df440b9e";
            string resourceGroupName = "resRg";
            string resourceName = "myDigitalTwinsService";
            string resourceId = "subResource";
            ResourceIdentifier digitalTwinsPrivateLinkResourceId = DigitalTwinsPrivateLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, resourceId);
            DigitalTwinsPrivateLinkResource digitalTwinsPrivateLinkResource = client.GetDigitalTwinsPrivateLinkResource(digitalTwinsPrivateLinkResourceId);

            // invoke the operation
            DigitalTwinsPrivateLinkResource result = await digitalTwinsPrivateLinkResource.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DigitalTwinsPrivateLinkResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
