// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.DigitalTwins.Core
{
    /// <summary> A query specification containing either a query statement or a continuation token from a previous query result. </summary>
    internal partial class QuerySpecification
    {
        /// <summary> Initializes a new instance of <see cref="QuerySpecification"/>. </summary>
        public QuerySpecification()
        {
        }

        /// <summary> Initializes a new instance of <see cref="QuerySpecification"/>. </summary>
        /// <param name="query"> The query to execute. This value is ignored if a continuation token is provided. </param>
        /// <param name="continuationToken"> A token which is used to retrieve the next set of results from a previous query. </param>
        internal QuerySpecification(string query, string continuationToken)
        {
            Query = query;
            ContinuationToken = continuationToken;
        }

        /// <summary> The query to execute. This value is ignored if a continuation token is provided. </summary>
        public string Query { get; set; }
        /// <summary> A token which is used to retrieve the next set of results from a previous query. </summary>
        public string ContinuationToken { get; set; }
    }
}
