// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.DigitalTwins.Core
{
    public partial class IncomingRelationship
    {
        internal static IncomingRelationship DeserializeIncomingRelationship(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string relationshipId = default;
            string sourceId = default;
            string relationshipName = default;
            string relationshipLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("$relationshipId"u8))
                {
                    relationshipId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("$sourceId"u8))
                {
                    sourceId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("$relationshipName"u8))
                {
                    relationshipName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("$relationshipLink"u8))
                {
                    relationshipLink = property.Value.GetString();
                    continue;
                }
            }
            return new IncomingRelationship(relationshipId, sourceId, relationshipName, relationshipLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static IncomingRelationship FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeIncomingRelationship(document.RootElement);
        }
    }
}
