// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.DigitalTwins.Core
{
    /// <summary> Status of the job. </summary>
    public readonly partial struct ImportJobStatus : IEquatable<ImportJobStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ImportJobStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ImportJobStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotstartedValue = "notstarted";
        private const string RunningValue = "running";
        private const string FailedValue = "failed";
        private const string SucceededValue = "succeeded";
        private const string CancellingValue = "cancelling";
        private const string CancelledValue = "cancelled";

        /// <summary> notstarted. </summary>
        public static ImportJobStatus Notstarted { get; } = new ImportJobStatus(NotstartedValue);
        /// <summary> running. </summary>
        public static ImportJobStatus Running { get; } = new ImportJobStatus(RunningValue);
        /// <summary> failed. </summary>
        public static ImportJobStatus Failed { get; } = new ImportJobStatus(FailedValue);
        /// <summary> succeeded. </summary>
        public static ImportJobStatus Succeeded { get; } = new ImportJobStatus(SucceededValue);
        /// <summary> cancelling. </summary>
        public static ImportJobStatus Cancelling { get; } = new ImportJobStatus(CancellingValue);
        /// <summary> cancelled. </summary>
        public static ImportJobStatus Cancelled { get; } = new ImportJobStatus(CancelledValue);
        /// <summary> Determines if two <see cref="ImportJobStatus"/> values are the same. </summary>
        public static bool operator ==(ImportJobStatus left, ImportJobStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ImportJobStatus"/> values are not the same. </summary>
        public static bool operator !=(ImportJobStatus left, ImportJobStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ImportJobStatus"/>. </summary>
        public static implicit operator ImportJobStatus(string value) => new ImportJobStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ImportJobStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ImportJobStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
