// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.DigitalTwins.Core
{
    internal partial class ImportJobCollection
    {
        internal static ImportJobCollection DeserializeImportJobCollection(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<ImportJob> value = default;
            string nextLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<ImportJob> array = new List<ImportJob>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ImportJob.DeserializeImportJob(item));
                    }
                    value = array;
                    continue;
                }
                if (property.NameEquals("nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
            }
            return new ImportJobCollection(value, nextLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ImportJobCollection FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeImportJobCollection(document.RootElement);
        }
    }
}
