// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.DigitalTwins.Core
{
    /// <summary> A job which contains a reference to the operations to perform, results, and execution metadata. </summary>
    public partial class ImportJob
    {
        /// <summary> Initializes a new instance of <see cref="ImportJob"/>. </summary>
        /// <param name="inputBlobUri"> The path to the input Azure storage blob that contains file(s) describing the operations to perform in the job. </param>
        /// <param name="outputBlobUri"> The path to the output Azure storage blob that will contain the errors and progress logs of import job. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="inputBlobUri"/> or <paramref name="outputBlobUri"/> is null. </exception>
        public ImportJob(Uri inputBlobUri, Uri outputBlobUri)
        {
            Argument.AssertNotNull(inputBlobUri, nameof(inputBlobUri));
            Argument.AssertNotNull(outputBlobUri, nameof(outputBlobUri));

            InputBlobUri = inputBlobUri;
            OutputBlobUri = outputBlobUri;
        }

        /// <summary> Initializes a new instance of <see cref="ImportJob"/>. </summary>
        /// <param name="id"> The identifier of the import job. </param>
        /// <param name="inputBlobUri"> The path to the input Azure storage blob that contains file(s) describing the operations to perform in the job. </param>
        /// <param name="outputBlobUri"> The path to the output Azure storage blob that will contain the errors and progress logs of import job. </param>
        /// <param name="status"> Status of the job. </param>
        /// <param name="createdDateTime"> Start time of the job. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </param>
        /// <param name="lastActionDateTime"> Last time service performed any action from the job. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </param>
        /// <param name="finishedDateTime"> End time of the job. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </param>
        /// <param name="purgeDateTime"> Time at which job will be purged by the service from the system. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </param>
        /// <param name="error"> Details of the error(s) that occurred executing the import job. </param>
        internal ImportJob(string id, Uri inputBlobUri, Uri outputBlobUri, ImportJobStatus? status, DateTimeOffset? createdDateTime, DateTimeOffset? lastActionDateTime, DateTimeOffset? finishedDateTime, DateTimeOffset? purgeDateTime, ResponseError error)
        {
            Id = id;
            InputBlobUri = inputBlobUri;
            OutputBlobUri = outputBlobUri;
            Status = status;
            CreatedDateTime = createdDateTime;
            LastActionDateTime = lastActionDateTime;
            FinishedDateTime = finishedDateTime;
            PurgeDateTime = purgeDateTime;
            Error = error;
        }

        /// <summary> The identifier of the import job. </summary>
        public string Id { get; }
        /// <summary> Start time of the job. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </summary>
        public DateTimeOffset? CreatedDateTime { get; }
        /// <summary> Last time service performed any action from the job. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </summary>
        public DateTimeOffset? LastActionDateTime { get; }
        /// <summary> End time of the job. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </summary>
        public DateTimeOffset? FinishedDateTime { get; }
        /// <summary> Time at which job will be purged by the service from the system. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </summary>
        public DateTimeOffset? PurgeDateTime { get; }
    }
}
