// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.DigitalTwins.Core
{
    /// <summary> A model definition and metadata for that model. </summary>
    public partial class DigitalTwinsModelData
    {
        /// <summary> Initializes a new instance of <see cref="DigitalTwinsModelData"/>. </summary>
        /// <param name="languageDisplayNames"> A language map that contains the localized display names as specified in the model definition. </param>
        /// <param name="languageDescriptions"> A language map that contains the localized descriptions as specified in the model definition. </param>
        /// <param name="id"> The id of the model as specified in the model definition. </param>
        /// <param name="uploadedOn"> The time the model was uploaded to the service. </param>
        /// <param name="decommissioned"> Indicates if the model is decommissioned. Decommissioned models cannot be referenced by newly created digital twins. </param>
        /// <param name="dtdlModel"> The model definition. </param>
        internal DigitalTwinsModelData(IReadOnlyDictionary<string, string> languageDisplayNames, IReadOnlyDictionary<string, string> languageDescriptions, string id, DateTimeOffset? uploadedOn, bool? decommissioned, string dtdlModel)
        {
            LanguageDisplayNames = languageDisplayNames;
            LanguageDescriptions = languageDescriptions;
            Id = id;
            UploadedOn = uploadedOn;
            Decommissioned = decommissioned;
            DtdlModel = dtdlModel;
        }
        /// <summary> The id of the model as specified in the model definition. </summary>
        public string Id { get; }
        /// <summary> Indicates if the model is decommissioned. Decommissioned models cannot be referenced by newly created digital twins. </summary>
        public bool? Decommissioned { get; }
    }
}
