// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.DigitalTwins.Core
{
    public partial class DigitalTwinsEventRoute : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("endpointName"u8);
            writer.WriteStringValue(EndpointName);
            writer.WritePropertyName("filter"u8);
            writer.WriteStringValue(Filter);
            writer.WriteEndObject();
        }

        internal static DigitalTwinsEventRoute DeserializeDigitalTwinsEventRoute(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            string endpointName = default;
            string filter = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("endpointName"u8))
                {
                    endpointName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("filter"u8))
                {
                    filter = property.Value.GetString();
                    continue;
                }
            }
            return new DigitalTwinsEventRoute(id, endpointName, filter);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DigitalTwinsEventRoute FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDigitalTwinsEventRoute(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
