// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.DigitalTwins.Core.Models;

namespace Azure.DigitalTwins.Core
{
    internal partial class ImportJobsRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of ImportJobsRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public ImportJobsRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint = null, string apiVersion = "2023-06-30")
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://digitaltwins-hostname");
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
        }

        internal HttpMessage CreateListRequest(ImportJobsListOptions importJobsListOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/imports", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (importJobsListOptions?.MaxItemsPerPage != null)
            {
                request.Headers.Add("max-items-per-page", importJobsListOptions.MaxItemsPerPage.Value);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary>
        /// Retrieves all import jobs.
        /// Status codes:
        /// * 200 OK
        /// </summary>
        /// <param name="importJobsListOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<ImportJobCollection>> ListAsync(ImportJobsListOptions importJobsListOptions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListRequest(importJobsListOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ImportJobCollection value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ImportJobCollection.DeserializeImportJobCollection(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Retrieves all import jobs.
        /// Status codes:
        /// * 200 OK
        /// </summary>
        /// <param name="importJobsListOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<ImportJobCollection> List(ImportJobsListOptions importJobsListOptions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListRequest(importJobsListOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ImportJobCollection value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ImportJobCollection.DeserializeImportJobCollection(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAddRequest(string id, ImportJob importJob, ImportJobsAddOptions importJobsAddOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/imports/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(importJob);
            request.Content = content;
            return message;
        }

        /// <summary>
        /// Creates an import job.
        /// Status codes:
        /// * 201 Created
        /// * 400 Bad Request
        ///   * JobLimitReached - The maximum number of import jobs allowed has been reached.
        ///   * ValidationFailed - The import job request is not valid.
        /// </summary>
        /// <param name="id"> The id for the import job. The id is unique within the service and case sensitive. </param>
        /// <param name="importJob"> The import job being added. </param>
        /// <param name="importJobsAddOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="importJob"/> is null. </exception>
        public async Task<Response<ImportJob>> AddAsync(string id, ImportJob importJob, ImportJobsAddOptions importJobsAddOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }
            if (importJob == null)
            {
                throw new ArgumentNullException(nameof(importJob));
            }

            using var message = CreateAddRequest(id, importJob, importJobsAddOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 201:
                    {
                        ImportJob value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ImportJob.DeserializeImportJob(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Creates an import job.
        /// Status codes:
        /// * 201 Created
        /// * 400 Bad Request
        ///   * JobLimitReached - The maximum number of import jobs allowed has been reached.
        ///   * ValidationFailed - The import job request is not valid.
        /// </summary>
        /// <param name="id"> The id for the import job. The id is unique within the service and case sensitive. </param>
        /// <param name="importJob"> The import job being added. </param>
        /// <param name="importJobsAddOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="importJob"/> is null. </exception>
        public Response<ImportJob> Add(string id, ImportJob importJob, ImportJobsAddOptions importJobsAddOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }
            if (importJob == null)
            {
                throw new ArgumentNullException(nameof(importJob));
            }

            using var message = CreateAddRequest(id, importJob, importJobsAddOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 201:
                    {
                        ImportJob value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ImportJob.DeserializeImportJob(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetByIdRequest(string id, ImportJobsGetByIdOptions importJobsGetByIdOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/imports/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary>
        /// Retrieves an import job.
        /// Status codes:
        /// * 200 OK
        /// * 404 Not Found
        ///   * ImportJobNotFound - The import job was not found.
        /// </summary>
        /// <param name="id"> The id for the import job. The id is unique within the service and case sensitive. </param>
        /// <param name="importJobsGetByIdOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public async Task<Response<ImportJob>> GetByIdAsync(string id, ImportJobsGetByIdOptions importJobsGetByIdOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateGetByIdRequest(id, importJobsGetByIdOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ImportJob value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ImportJob.DeserializeImportJob(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Retrieves an import job.
        /// Status codes:
        /// * 200 OK
        /// * 404 Not Found
        ///   * ImportJobNotFound - The import job was not found.
        /// </summary>
        /// <param name="id"> The id for the import job. The id is unique within the service and case sensitive. </param>
        /// <param name="importJobsGetByIdOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public Response<ImportJob> GetById(string id, ImportJobsGetByIdOptions importJobsGetByIdOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateGetByIdRequest(id, importJobsGetByIdOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ImportJob value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ImportJob.DeserializeImportJob(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDeleteRequest(string id, ImportJobsDeleteOptions importJobsDeleteOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/imports/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary>
        /// Deletes an import job.
        /// Status codes:
        /// * 204 No Content
        /// * 400 Bad Request
        ///   * ValidationFailed - The import job request is not valid.
        /// </summary>
        /// <param name="id"> The id for the import job. The id is unique within the service and case sensitive. </param>
        /// <param name="importJobsDeleteOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public async Task<Response> DeleteAsync(string id, ImportJobsDeleteOptions importJobsDeleteOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateDeleteRequest(id, importJobsDeleteOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Deletes an import job.
        /// Status codes:
        /// * 204 No Content
        /// * 400 Bad Request
        ///   * ValidationFailed - The import job request is not valid.
        /// </summary>
        /// <param name="id"> The id for the import job. The id is unique within the service and case sensitive. </param>
        /// <param name="importJobsDeleteOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public Response Delete(string id, ImportJobsDeleteOptions importJobsDeleteOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateDeleteRequest(id, importJobsDeleteOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCancelRequest(string id, ImportJobsCancelOptions importJobsCancelOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/imports/", false);
            uri.AppendPath(id, true);
            uri.AppendPath("/cancel", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary>
        /// Cancels an import job.
        /// Status codes:
        /// * 200 Request Accepted
        /// * 400 Bad Request
        ///   * ValidationFailed - The import job request is not valid.
        /// </summary>
        /// <param name="id"> The id for the import job. The id is unique within the service and case sensitive. </param>
        /// <param name="importJobsCancelOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public async Task<Response<ImportJob>> CancelAsync(string id, ImportJobsCancelOptions importJobsCancelOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateCancelRequest(id, importJobsCancelOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ImportJob value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ImportJob.DeserializeImportJob(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Cancels an import job.
        /// Status codes:
        /// * 200 Request Accepted
        /// * 400 Bad Request
        ///   * ValidationFailed - The import job request is not valid.
        /// </summary>
        /// <param name="id"> The id for the import job. The id is unique within the service and case sensitive. </param>
        /// <param name="importJobsCancelOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public Response<ImportJob> Cancel(string id, ImportJobsCancelOptions importJobsCancelOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateCancelRequest(id, importJobsCancelOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ImportJob value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ImportJob.DeserializeImportJob(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListNextPageRequest(string nextLink, ImportJobsListOptions importJobsListOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            if (importJobsListOptions?.MaxItemsPerPage != null)
            {
                request.Headers.Add("max-items-per-page", importJobsListOptions.MaxItemsPerPage.Value);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary>
        /// Retrieves all import jobs.
        /// Status codes:
        /// * 200 OK
        /// </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="importJobsListOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<ImportJobCollection>> ListNextPageAsync(string nextLink, ImportJobsListOptions importJobsListOptions = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListNextPageRequest(nextLink, importJobsListOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ImportJobCollection value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ImportJobCollection.DeserializeImportJobCollection(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Retrieves all import jobs.
        /// Status codes:
        /// * 200 OK
        /// </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="importJobsListOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<ImportJobCollection> ListNextPage(string nextLink, ImportJobsListOptions importJobsListOptions = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListNextPageRequest(nextLink, importJobsListOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ImportJobCollection value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ImportJobCollection.DeserializeImportJobCollection(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
