// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.DigitalTwins.Core
{
    internal partial class EventRoutesRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of EventRoutesRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public EventRoutesRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint = null, string apiVersion = "2023-06-30")
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://digitaltwins-hostname");
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
        }

        internal HttpMessage CreateListRequest(GetDigitalTwinsEventRoutesOptions getDigitalTwinsEventRoutesOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/eventroutes", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (getDigitalTwinsEventRoutesOptions?.MaxItemsPerPage != null)
            {
                request.Headers.Add("max-items-per-page", getDigitalTwinsEventRoutesOptions.MaxItemsPerPage.Value);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary>
        /// Retrieves all event routes.
        /// Status codes:
        /// * 200 OK
        /// </summary>
        /// <param name="getDigitalTwinsEventRoutesOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<DigitalTwinsEventRouteCollection>> ListAsync(GetDigitalTwinsEventRoutesOptions getDigitalTwinsEventRoutesOptions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListRequest(getDigitalTwinsEventRoutesOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DigitalTwinsEventRouteCollection value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DigitalTwinsEventRouteCollection.DeserializeDigitalTwinsEventRouteCollection(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Retrieves all event routes.
        /// Status codes:
        /// * 200 OK
        /// </summary>
        /// <param name="getDigitalTwinsEventRoutesOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<DigitalTwinsEventRouteCollection> List(GetDigitalTwinsEventRoutesOptions getDigitalTwinsEventRoutesOptions = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListRequest(getDigitalTwinsEventRoutesOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DigitalTwinsEventRouteCollection value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DigitalTwinsEventRouteCollection.DeserializeDigitalTwinsEventRouteCollection(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetByIdRequest(string id, GetDigitalTwinsEventRouteOptions getDigitalTwinsEventRouteOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/eventroutes/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary>
        /// Retrieves an event route.
        /// Status codes:
        /// * 200 OK
        /// * 404 Not Found
        ///   * EventRouteNotFound - The event route was not found.
        /// </summary>
        /// <param name="id"> The id for an event route. The id is unique within event routes and case sensitive. </param>
        /// <param name="getDigitalTwinsEventRouteOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public async Task<Response<DigitalTwinsEventRoute>> GetByIdAsync(string id, GetDigitalTwinsEventRouteOptions getDigitalTwinsEventRouteOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateGetByIdRequest(id, getDigitalTwinsEventRouteOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DigitalTwinsEventRoute value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DigitalTwinsEventRoute.DeserializeDigitalTwinsEventRoute(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Retrieves an event route.
        /// Status codes:
        /// * 200 OK
        /// * 404 Not Found
        ///   * EventRouteNotFound - The event route was not found.
        /// </summary>
        /// <param name="id"> The id for an event route. The id is unique within event routes and case sensitive. </param>
        /// <param name="getDigitalTwinsEventRouteOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public Response<DigitalTwinsEventRoute> GetById(string id, GetDigitalTwinsEventRouteOptions getDigitalTwinsEventRouteOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateGetByIdRequest(id, getDigitalTwinsEventRouteOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DigitalTwinsEventRoute value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DigitalTwinsEventRoute.DeserializeDigitalTwinsEventRoute(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAddRequest(string id, DigitalTwinsEventRoute digitalTwinsEventRoute, CreateOrReplaceEventRouteOptions createOrReplaceEventRouteOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/eventroutes/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(digitalTwinsEventRoute);
            request.Content = content;
            return message;
        }

        /// <summary>
        /// Adds or replaces an event route.
        /// Status codes:
        /// * 204 No Content
        /// * 400 Bad Request
        ///   * EventRouteEndpointInvalid - The endpoint provided does not exist or is not active.
        ///   * EventRouteFilterInvalid - The event route filter is invalid.
        ///   * EventRouteIdInvalid - The event route id is invalid.
        ///   * LimitExceeded - The maximum number of event routes allowed has been reached.
        /// </summary>
        /// <param name="id"> The id for an event route. The id is unique within event routes and case sensitive. </param>
        /// <param name="digitalTwinsEventRoute"> The event route data. </param>
        /// <param name="createOrReplaceEventRouteOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="digitalTwinsEventRoute"/> is null. </exception>
        public async Task<Response> AddAsync(string id, DigitalTwinsEventRoute digitalTwinsEventRoute, CreateOrReplaceEventRouteOptions createOrReplaceEventRouteOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }
            if (digitalTwinsEventRoute == null)
            {
                throw new ArgumentNullException(nameof(digitalTwinsEventRoute));
            }

            using var message = CreateAddRequest(id, digitalTwinsEventRoute, createOrReplaceEventRouteOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Adds or replaces an event route.
        /// Status codes:
        /// * 204 No Content
        /// * 400 Bad Request
        ///   * EventRouteEndpointInvalid - The endpoint provided does not exist or is not active.
        ///   * EventRouteFilterInvalid - The event route filter is invalid.
        ///   * EventRouteIdInvalid - The event route id is invalid.
        ///   * LimitExceeded - The maximum number of event routes allowed has been reached.
        /// </summary>
        /// <param name="id"> The id for an event route. The id is unique within event routes and case sensitive. </param>
        /// <param name="digitalTwinsEventRoute"> The event route data. </param>
        /// <param name="createOrReplaceEventRouteOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="digitalTwinsEventRoute"/> is null. </exception>
        public Response Add(string id, DigitalTwinsEventRoute digitalTwinsEventRoute, CreateOrReplaceEventRouteOptions createOrReplaceEventRouteOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }
            if (digitalTwinsEventRoute == null)
            {
                throw new ArgumentNullException(nameof(digitalTwinsEventRoute));
            }

            using var message = CreateAddRequest(id, digitalTwinsEventRoute, createOrReplaceEventRouteOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDeleteRequest(string id, DeleteEventRouteOptions deleteEventRouteOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/eventroutes/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary>
        /// Deletes an event route.
        /// Status codes:
        /// * 204 No Content
        /// * 404 Not Found
        ///   * EventRouteNotFound - The event route was not found.
        /// </summary>
        /// <param name="id"> The id for an event route. The id is unique within event routes and case sensitive. </param>
        /// <param name="deleteEventRouteOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public async Task<Response> DeleteAsync(string id, DeleteEventRouteOptions deleteEventRouteOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateDeleteRequest(id, deleteEventRouteOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Deletes an event route.
        /// Status codes:
        /// * 204 No Content
        /// * 404 Not Found
        ///   * EventRouteNotFound - The event route was not found.
        /// </summary>
        /// <param name="id"> The id for an event route. The id is unique within event routes and case sensitive. </param>
        /// <param name="deleteEventRouteOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public Response Delete(string id, DeleteEventRouteOptions deleteEventRouteOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateDeleteRequest(id, deleteEventRouteOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListNextPageRequest(string nextLink, GetDigitalTwinsEventRoutesOptions getDigitalTwinsEventRoutesOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            if (getDigitalTwinsEventRoutesOptions?.MaxItemsPerPage != null)
            {
                request.Headers.Add("max-items-per-page", getDigitalTwinsEventRoutesOptions.MaxItemsPerPage.Value);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary>
        /// Retrieves all event routes.
        /// Status codes:
        /// * 200 OK
        /// </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="getDigitalTwinsEventRoutesOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<DigitalTwinsEventRouteCollection>> ListNextPageAsync(string nextLink, GetDigitalTwinsEventRoutesOptions getDigitalTwinsEventRoutesOptions = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListNextPageRequest(nextLink, getDigitalTwinsEventRoutesOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DigitalTwinsEventRouteCollection value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DigitalTwinsEventRouteCollection.DeserializeDigitalTwinsEventRouteCollection(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Retrieves all event routes.
        /// Status codes:
        /// * 200 OK
        /// </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="getDigitalTwinsEventRoutesOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<DigitalTwinsEventRouteCollection> ListNextPage(string nextLink, GetDigitalTwinsEventRoutesOptions getDigitalTwinsEventRoutesOptions = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListNextPageRequest(nextLink, getDigitalTwinsEventRoutesOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DigitalTwinsEventRouteCollection value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DigitalTwinsEventRouteCollection.DeserializeDigitalTwinsEventRouteCollection(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
