// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.DigitalTwins.Core
{
    internal partial class DigitalTwinsRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of DigitalTwinsRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public DigitalTwinsRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint = null, string apiVersion = "2023-06-30")
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://digitaltwins-hostname");
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
        }

        internal HttpMessage CreateGetByIdRequest(string id, GetDigitalTwinOptions getDigitalTwinOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/digitaltwins/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateDeleteRequest(string id, DeleteDigitalTwinOptions deleteDigitalTwinOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/digitaltwins/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (deleteDigitalTwinOptions?.IfMatch != null)
            {
                request.Headers.Add("If-Match", deleteDigitalTwinOptions.IfMatch);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary>
        /// Deletes a digital twin. All relationships referencing the digital twin must already be deleted.
        /// Status codes:
        /// * 204 No Content
        /// * 400 Bad Request
        ///   * InvalidArgument - The digital twin id is invalid.
        ///   * RelationshipsNotDeleted - The digital twin contains relationships.
        /// * 404 Not Found
        ///   * DigitalTwinNotFound - The digital twin was not found.
        /// * 412 Precondition Failed
        ///   * PreconditionFailed - The precondition check (If-Match or If-None-Match) failed.
        /// </summary>
        /// <param name="id"> The id of the digital twin. The id is unique within the service and case sensitive. </param>
        /// <param name="deleteDigitalTwinOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public async Task<Response> DeleteAsync(string id, DeleteDigitalTwinOptions deleteDigitalTwinOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateDeleteRequest(id, deleteDigitalTwinOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Deletes a digital twin. All relationships referencing the digital twin must already be deleted.
        /// Status codes:
        /// * 204 No Content
        /// * 400 Bad Request
        ///   * InvalidArgument - The digital twin id is invalid.
        ///   * RelationshipsNotDeleted - The digital twin contains relationships.
        /// * 404 Not Found
        ///   * DigitalTwinNotFound - The digital twin was not found.
        /// * 412 Precondition Failed
        ///   * PreconditionFailed - The precondition check (If-Match or If-None-Match) failed.
        /// </summary>
        /// <param name="id"> The id of the digital twin. The id is unique within the service and case sensitive. </param>
        /// <param name="deleteDigitalTwinOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public Response Delete(string id, DeleteDigitalTwinOptions deleteDigitalTwinOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateDeleteRequest(id, deleteDigitalTwinOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateUpdateRequest(string id, IEnumerable<object> patchDocument, UpdateDigitalTwinOptions updateDigitalTwinOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/digitaltwins/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (updateDigitalTwinOptions?.IfMatch != null)
            {
                request.Headers.Add("If-Match", updateDigitalTwinOptions.IfMatch);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json-patch+json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteStartArray();
            foreach (var item in patchDocument)
            {
                if (item == null)
                {
                    content.JsonWriter.WriteNullValue();
                    continue;
                }
                content.JsonWriter.WriteObjectValue<object>(item);
            }
            content.JsonWriter.WriteEndArray();
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetRelationshipByIdRequest(string id, string relationshipId, GetRelationshipOptions getRelationshipOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/digitaltwins/", false);
            uri.AppendPath(id, true);
            uri.AppendPath("/relationships/", false);
            uri.AppendPath(relationshipId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateAddRelationshipRequest(string id, string relationshipId, object relationship, CreateOrReplaceRelationshipOptions createOrReplaceRelationshipOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/digitaltwins/", false);
            uri.AppendPath(id, true);
            uri.AppendPath("/relationships/", false);
            uri.AppendPath(relationshipId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (createOrReplaceRelationshipOptions?.IfNoneMatch != null)
            {
                request.Headers.Add("If-None-Match", createOrReplaceRelationshipOptions.IfNoneMatch);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue<object>(relationship);
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDeleteRelationshipRequest(string id, string relationshipId, DeleteRelationshipOptions deleteRelationshipOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/digitaltwins/", false);
            uri.AppendPath(id, true);
            uri.AppendPath("/relationships/", false);
            uri.AppendPath(relationshipId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (deleteRelationshipOptions?.IfMatch != null)
            {
                request.Headers.Add("If-Match", deleteRelationshipOptions.IfMatch);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary>
        /// Deletes a relationship between two digital twins.
        /// Status codes:
        /// * 204 No Content
        /// * 400 Bad Request
        ///   * InvalidArgument - The digital twin id or relationship id is invalid.
        /// * 404 Not Found
        ///   * DigitalTwinNotFound - The digital twin was not found.
        ///   * RelationshipNotFound - The relationship was not found.
        /// * 412 Precondition Failed
        ///   * PreconditionFailed - The precondition check (If-Match or If-None-Match) failed.
        /// </summary>
        /// <param name="id"> The id of the digital twin. The id is unique within the service and case sensitive. </param>
        /// <param name="relationshipId"> The id of the relationship. The id is unique within the digital twin and case sensitive. </param>
        /// <param name="deleteRelationshipOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="relationshipId"/> is null. </exception>
        public async Task<Response> DeleteRelationshipAsync(string id, string relationshipId, DeleteRelationshipOptions deleteRelationshipOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }
            if (relationshipId == null)
            {
                throw new ArgumentNullException(nameof(relationshipId));
            }

            using var message = CreateDeleteRelationshipRequest(id, relationshipId, deleteRelationshipOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Deletes a relationship between two digital twins.
        /// Status codes:
        /// * 204 No Content
        /// * 400 Bad Request
        ///   * InvalidArgument - The digital twin id or relationship id is invalid.
        /// * 404 Not Found
        ///   * DigitalTwinNotFound - The digital twin was not found.
        ///   * RelationshipNotFound - The relationship was not found.
        /// * 412 Precondition Failed
        ///   * PreconditionFailed - The precondition check (If-Match or If-None-Match) failed.
        /// </summary>
        /// <param name="id"> The id of the digital twin. The id is unique within the service and case sensitive. </param>
        /// <param name="relationshipId"> The id of the relationship. The id is unique within the digital twin and case sensitive. </param>
        /// <param name="deleteRelationshipOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="relationshipId"/> is null. </exception>
        public Response DeleteRelationship(string id, string relationshipId, DeleteRelationshipOptions deleteRelationshipOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }
            if (relationshipId == null)
            {
                throw new ArgumentNullException(nameof(relationshipId));
            }

            using var message = CreateDeleteRelationshipRequest(id, relationshipId, deleteRelationshipOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateUpdateRelationshipRequest(string id, string relationshipId, IEnumerable<object> patchDocument, UpdateRelationshipOptions updateRelationshipOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/digitaltwins/", false);
            uri.AppendPath(id, true);
            uri.AppendPath("/relationships/", false);
            uri.AppendPath(relationshipId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (updateRelationshipOptions?.IfMatch != null)
            {
                request.Headers.Add("If-Match", updateRelationshipOptions.IfMatch);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json-patch+json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteStartArray();
            foreach (var item in patchDocument)
            {
                if (item == null)
                {
                    content.JsonWriter.WriteNullValue();
                    continue;
                }
                content.JsonWriter.WriteObjectValue<object>(item);
            }
            content.JsonWriter.WriteEndArray();
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateListRelationshipsRequest(string id, string relationshipName, GetRelationshipsOptions getRelationshipsOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/digitaltwins/", false);
            uri.AppendPath(id, true);
            uri.AppendPath("/relationships", false);
            if (relationshipName != null)
            {
                uri.AppendQuery("relationshipName", relationshipName, true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateListIncomingRelationshipsRequest(string id, GetIncomingRelationshipsOptions getIncomingRelationshipsOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/digitaltwins/", false);
            uri.AppendPath(id, true);
            uri.AppendPath("/incomingrelationships", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary>
        /// Retrieves all incoming relationship for a digital twin.
        /// Status codes:
        /// * 200 OK
        /// * 400 Bad Request
        ///   * InvalidArgument - The digital twin id is invalid.
        /// * 404 Not Found
        ///   * DigitalTwinNotFound - The digital twin was not found.
        /// </summary>
        /// <param name="id"> The id of the digital twin. The id is unique within the service and case sensitive. </param>
        /// <param name="getIncomingRelationshipsOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public async Task<Response<IncomingRelationshipCollection>> ListIncomingRelationshipsAsync(string id, GetIncomingRelationshipsOptions getIncomingRelationshipsOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateListIncomingRelationshipsRequest(id, getIncomingRelationshipsOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncomingRelationshipCollection value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = IncomingRelationshipCollection.DeserializeIncomingRelationshipCollection(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Retrieves all incoming relationship for a digital twin.
        /// Status codes:
        /// * 200 OK
        /// * 400 Bad Request
        ///   * InvalidArgument - The digital twin id is invalid.
        /// * 404 Not Found
        ///   * DigitalTwinNotFound - The digital twin was not found.
        /// </summary>
        /// <param name="id"> The id of the digital twin. The id is unique within the service and case sensitive. </param>
        /// <param name="getIncomingRelationshipsOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public Response<IncomingRelationshipCollection> ListIncomingRelationships(string id, GetIncomingRelationshipsOptions getIncomingRelationshipsOptions = null, CancellationToken cancellationToken = default)
        {
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateListIncomingRelationshipsRequest(id, getIncomingRelationshipsOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncomingRelationshipCollection value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = IncomingRelationshipCollection.DeserializeIncomingRelationshipCollection(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateSendTelemetryRequest(string id, string messageId, object telemetry, string telemetrySourceTime, PublishTelemetryOptions publishTelemetryOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/digitaltwins/", false);
            uri.AppendPath(id, true);
            uri.AppendPath("/telemetry", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Message-Id", messageId);
            if (telemetrySourceTime != null)
            {
                request.Headers.Add("Telemetry-Source-Time", telemetrySourceTime);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue<object>(telemetry);
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateSendComponentTelemetryRequest(string id, string componentPath, string messageId, object telemetry, string telemetrySourceTime, PublishComponentTelemetryOptions publishComponentTelemetryOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/digitaltwins/", false);
            uri.AppendPath(id, true);
            uri.AppendPath("/components/", false);
            uri.AppendPath(componentPath, true);
            uri.AppendPath("/telemetry", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Message-Id", messageId);
            if (telemetrySourceTime != null)
            {
                request.Headers.Add("Telemetry-Source-Time", telemetrySourceTime);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue<object>(telemetry);
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetComponentRequest(string id, string componentPath, GetComponentOptions getComponentOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/digitaltwins/", false);
            uri.AppendPath(id, true);
            uri.AppendPath("/components/", false);
            uri.AppendPath(componentPath, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateUpdateComponentRequest(string id, string componentPath, IEnumerable<object> patchDocument, UpdateComponentOptions updateComponentOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/digitaltwins/", false);
            uri.AppendPath(id, true);
            uri.AppendPath("/components/", false);
            uri.AppendPath(componentPath, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (updateComponentOptions?.IfMatch != null)
            {
                request.Headers.Add("If-Match", updateComponentOptions.IfMatch);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json-patch+json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteStartArray();
            foreach (var item in patchDocument)
            {
                if (item == null)
                {
                    content.JsonWriter.WriteNullValue();
                    continue;
                }
                content.JsonWriter.WriteObjectValue<object>(item);
            }
            content.JsonWriter.WriteEndArray();
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateListRelationshipsNextPageRequest(string nextLink, string id, string relationshipName, GetRelationshipsOptions getRelationshipsOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateListIncomingRelationshipsNextPageRequest(string nextLink, string id, GetIncomingRelationshipsOptions getIncomingRelationshipsOptions)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary>
        /// Retrieves all incoming relationship for a digital twin.
        /// Status codes:
        /// * 200 OK
        /// * 400 Bad Request
        ///   * InvalidArgument - The digital twin id is invalid.
        /// * 404 Not Found
        ///   * DigitalTwinNotFound - The digital twin was not found.
        /// </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="id"> The id of the digital twin. The id is unique within the service and case sensitive. </param>
        /// <param name="getIncomingRelationshipsOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="id"/> is null. </exception>
        public async Task<Response<IncomingRelationshipCollection>> ListIncomingRelationshipsNextPageAsync(string nextLink, string id, GetIncomingRelationshipsOptions getIncomingRelationshipsOptions = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateListIncomingRelationshipsNextPageRequest(nextLink, id, getIncomingRelationshipsOptions);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncomingRelationshipCollection value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = IncomingRelationshipCollection.DeserializeIncomingRelationshipCollection(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// Retrieves all incoming relationship for a digital twin.
        /// Status codes:
        /// * 200 OK
        /// * 400 Bad Request
        ///   * InvalidArgument - The digital twin id is invalid.
        /// * 404 Not Found
        ///   * DigitalTwinNotFound - The digital twin was not found.
        /// </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="id"> The id of the digital twin. The id is unique within the service and case sensitive. </param>
        /// <param name="getIncomingRelationshipsOptions"> Parameter group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="id"/> is null. </exception>
        public Response<IncomingRelationshipCollection> ListIncomingRelationshipsNextPage(string nextLink, string id, GetIncomingRelationshipsOptions getIncomingRelationshipsOptions = null, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }
            if (id == null)
            {
                throw new ArgumentNullException(nameof(id));
            }

            using var message = CreateListIncomingRelationshipsNextPageRequest(nextLink, id, getIncomingRelationshipsOptions);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IncomingRelationshipCollection value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = IncomingRelationshipCollection.DeserializeIncomingRelationshipCollection(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
