# Azure IoT Digital Twins client library for .NET

This library provides access to the Azure Digital Twins service for managing twins, models, relationships, etc.

  [Source code][source] | [Package (nuget)][package]

## Getting started

The complete Microsoft Azure SDK can be downloaded from the [Microsoft Azure downloads][microsoft_sdk_download] page, and it ships with support for building deployment packages, integrating with tooling, rich command line tooling, and more.

For the best development experience, developers should use the official Microsoft NuGet packages for libraries. NuGet packages are regularly updated with new functionality and hotfixes.

### Install the package

Install the Azure Digital Twins client library for .NET with [NuGet][nuget]:

```dotnetcli
dotnet add package Azure.DigitalTwins.Core
```

View the package details at [nuget.org][adt_nuget].

### Prerequisites

- A Microsoft Azure Subscription
  - To call Microsoft Azure services, create an [Azure subscription][azure_sub].
- An Azure Digital Twins instance
  - In order to use the Azure Digital Twins SDK, first create a Digital Twins instance using one of options:
    - Using [Azure portal][azure_portal]
    - Using [Azure Management APIs][azure_rest_api]
    - Using [Azure CLI][azure_cli]
      - You will need to install azure cli and the [Azure IoT extension][iot_cli_extension] for Azure CLI.
      - Refer to [IoT CLI documentation][iot_cli_doc] for more information on how to create and interact with your Digital Twins instance.

### Authenticate the Client

In order to interact with the Azure Digital Twins service, you will need to create an instance of a [TokenCredential class][token_credential] and pass it to the constructor of your [DigitalTwinsClient][digital_twins_client].

## Key concepts

Azure Digital Twins is an Azure IoT service that creates comprehensive models of the physical environment.
It can create spatial intelligence graphs to model the relationships and interactions between people, spaces, and devices.

You can learn more about Azure Digital Twins by visiting [Azure Digital Twins Documentation][digital_twins_documentation]

### Thread safety
We guarantee that all client instance methods are thread-safe and independent of each other ([guideline](https://azure.github.io/azure-sdk/dotnet_introduction.html#dotnet-service-methods-thread-safety)). This ensures that the recommendation of reusing client instances is always safe, even across threads.

### Additional concepts
<!-- CLIENT COMMON BAR -->
[Client options](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/README.md#configuring-service-clients-using-clientoptions) |
[Accessing the response](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/README.md#accessing-http-response-details-using-responset) |
[Long-running operations](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/README.md#consuming-long-running-operations-using-operationt) |
[Handling failures](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/README.md#reporting-errors-requestfailedexception) |
[Diagnostics](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/Diagnostics.md) |
[Mocking](https://learn.microsoft.com/dotnet/azure/sdk/unit-testing-mocking) |
[Client lifetime](https://devblogs.microsoft.com/azure-sdk/lifetime-management-and-thread-safety-guarantees-of-azure-sdk-net-clients/)
<!-- CLIENT COMMON BAR -->

## Examples

You can familiarize yourself with different APIs using [samples for Digital Twins](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/digitaltwins/Azure.DigitalTwins.Core/samples/).

## Source code folder structure

### /src

The Digital Twins public client, `DigitalTwinsClient`, and the additional configuration options, `DigitalTwinsClientOptions`, that can be sent to the Digital Twins service.

### /src/Generated

The code generated by autorest using the swagger file defined in the autorest config file.

To regenerate the code, run the powershell script [generate.ps1](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/digitaltwins/Azure.DigitalTwins.Core/src/generate.ps1).

Any time the client library code is updated, the following scripts need to be run:

- [Export-AdtApis.ps1](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/digitaltwins/Export-AdtApis.ps1), which will update the [API surface document](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/digitaltwins/Azure.DigitalTwins.Core/api/Azure.DigitalTwins.Core.netstandard2.0.cs).
- [Update-Snippets.ps1](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/digitaltwins/Update-AdtSnippets.ps1), which will update all the code snippets in the readme files and in the client documentation comments.

### /src/Customized

The customzied code written to override the following behavior of auto-generated code:

- Rename some of the generated types, eg. [GetModelsOptions](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/digitaltwins/Azure.DigitalTwins.Core/src/Customized/Models/GetModelsOptions.cs)
- Declare some of the generated types as **internal**, instead of the autorest default of **public**.
- Declare some methods to accept input parameters as **strings** instead of **objects**.
- Declare some methods to return the response as **strings** instead of **objects**.

### /src/Models

Model classes useful for use with the Digital Twins client operations.

### /src/Properties

Assembly properties required for running unit tests.

### /src/Serialization

Serialization helpers provided to help serialize/deserialize commonly used types within the Digital Twins service.

## Troubleshooting

All service operations will throw RequestFailedException on failure reported by the service, with helpful error codes and other information.

For example, use the `GetModelAsync` operation to check if the model exists before creating it, catch only when that specific [HttpStatusCode][http_status_code] is specified.

```csharp
try
{
    Response<ModelData> desiredModel = await DigitalTwinsClient.GetModelAsync(desiredModelId);
}
catch (RequestFailedException ex) when (ex.Status == (int)HttpStatusCode.NotFound)
{
    // Model does not exist, so create it.
}
```

## Next steps

See implementation examples with our [code samples](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/digitaltwins/Azure.DigitalTwins.Core/samples).

## Contributing

This project welcomes contributions and suggestions.
Most contributions require you to agree to a Contributor License Agreement (CLA) declaring that you have the right to, and actually do, grant us the rights to use your contribution.
For details, visit <https://cla.microsoft.com.>

When you submit a pull request, a CLA-bot will automatically determine whether you need to provide a CLA and decorate the PR appropriately (e.g., label, comment).
Simply follow the instructions provided by the bot.
You will only need to do this once across all repos using our CLA.

This project has adopted the [Microsoft Open Source Code of Conduct][code_of_conduct].
For more information see the [Code of Conduct FAQ][code_of_conduct_faq] or contact opencode@microsoft.com with any additional questions or comments.

<!-- LINKS -->
[microsoft_sdk_download]: https://azure.microsoft.com/downloads/?sdk=net
[azure_sdk_target_frameworks]: https://github.com/azure/azure-sdk-for-net#target-frameworks
[azure_cli]: https://docs.microsoft.com/cli/azure
[azure_sub]: https://azure.microsoft.com/free/dotnet/
[source]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/digitaltwins/Azure.DigitalTwins.Core/src
[package]: https://www.nuget.org/packages/Azure.DigitalTwins.Core
[code_of_conduct]: https://opensource.microsoft.com/codeofconduct/
[code_of_conduct_faq]: https://opensource.microsoft.com/codeofconduct/faq/
[nuget]: https://www.nuget.org/
[azure_portal]: https://portal.azure.com/
[azure_rest_api]: https://docs.microsoft.com/rest/api/azure/
[azure_core_library]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/core/Azure.Core
[token_credential]: https://docs.microsoft.com/dotnet/api/azure.core.tokencredential?view=azure-dotnet
[digital_twins_client]: https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/digitaltwins/Azure.DigitalTwins.Core/src/DigitalTwinsClient.cs
[digital_twins_documentation]: https://docs.microsoft.com/azure/digital-twins/
[iot_cli_extension]: https://github.com/Azure/azure-iot-cli-extension/releases
[iot_cli_doc]: https://docs.microsoft.com/cli/azure/azure-cli-reference-for-iot
[http_status_code]: https://docs.microsoft.com/dotnet/api/system.net.httpstatuscode?view=netcore-3.1
[adt_nuget]: https://www.nuget.org/packages/Azure.DigitalTwins.Core
