// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Request body for detaching data disk from a virtual machine. </summary>
    public partial class DevTestLabVmDetachDataDiskContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabVmDetachDataDiskContent"/>. </summary>
        public DevTestLabVmDetachDataDiskContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabVmDetachDataDiskContent"/>. </summary>
        /// <param name="existingLabDiskId"> Specifies the disk resource ID to detach from virtual machine. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabVmDetachDataDiskContent(ResourceIdentifier existingLabDiskId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExistingLabDiskId = existingLabDiskId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Specifies the disk resource ID to detach from virtual machine. </summary>
        public ResourceIdentifier ExistingLabDiskId { get; set; }
    }
}
