// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Properties of a user's secret store. </summary>
    public partial class DevTestLabUserSecretStore
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabUserSecretStore"/>. </summary>
        public DevTestLabUserSecretStore()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabUserSecretStore"/>. </summary>
        /// <param name="keyVaultUri"> The URI of the user's Key vault. </param>
        /// <param name="keyVaultId"> The ID of the user's Key vault. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabUserSecretStore(Uri keyVaultUri, ResourceIdentifier keyVaultId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyVaultUri = keyVaultUri;
            KeyVaultId = keyVaultId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The URI of the user's Key vault. </summary>
        public Uri KeyVaultUri { get; set; }
        /// <summary> The ID of the user's Key vault. </summary>
        public ResourceIdentifier KeyVaultId { get; set; }
    }
}
