// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)). </summary>
    public readonly partial struct DevTestLabUsagePermissionType : IEquatable<DevTestLabUsagePermissionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevTestLabUsagePermissionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevTestLabUsagePermissionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string DenyValue = "Deny";
        private const string AllowValue = "Allow";

        /// <summary> Default. </summary>
        public static DevTestLabUsagePermissionType Default { get; } = new DevTestLabUsagePermissionType(DefaultValue);
        /// <summary> Deny. </summary>
        public static DevTestLabUsagePermissionType Deny { get; } = new DevTestLabUsagePermissionType(DenyValue);
        /// <summary> Allow. </summary>
        public static DevTestLabUsagePermissionType Allow { get; } = new DevTestLabUsagePermissionType(AllowValue);
        /// <summary> Determines if two <see cref="DevTestLabUsagePermissionType"/> values are the same. </summary>
        public static bool operator ==(DevTestLabUsagePermissionType left, DevTestLabUsagePermissionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevTestLabUsagePermissionType"/> values are not the same. </summary>
        public static bool operator !=(DevTestLabUsagePermissionType left, DevTestLabUsagePermissionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevTestLabUsagePermissionType"/>. </summary>
        public static implicit operator DevTestLabUsagePermissionType(string value) => new DevTestLabUsagePermissionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevTestLabUsagePermissionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevTestLabUsagePermissionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
