// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Properties of a cost target. </summary>
    public partial class DevTestLabTargetCost
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabTargetCost"/>. </summary>
        public DevTestLabTargetCost()
        {
            CostThresholds = new ChangeTrackingList<DevTestLabCostThreshold>();
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabTargetCost"/>. </summary>
        /// <param name="status"> Target cost status. </param>
        /// <param name="target"> Lab target cost. </param>
        /// <param name="costThresholds"> Cost thresholds. </param>
        /// <param name="cycleStartOn"> Reporting cycle start date. </param>
        /// <param name="cycleEndOn"> Reporting cycle end date. </param>
        /// <param name="cycleType"> Reporting cycle type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabTargetCost(DevTestLabTargetCostStatus? status, int? target, IList<DevTestLabCostThreshold> costThresholds, DateTimeOffset? cycleStartOn, DateTimeOffset? cycleEndOn, DevTestLabReportingCycleType? cycleType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            Target = target;
            CostThresholds = costThresholds;
            CycleStartOn = cycleStartOn;
            CycleEndOn = cycleEndOn;
            CycleType = cycleType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Target cost status. </summary>
        public DevTestLabTargetCostStatus? Status { get; set; }
        /// <summary> Lab target cost. </summary>
        public int? Target { get; set; }
        /// <summary> Cost thresholds. </summary>
        public IList<DevTestLabCostThreshold> CostThresholds { get; }
        /// <summary> Reporting cycle start date. </summary>
        public DateTimeOffset? CycleStartOn { get; set; }
        /// <summary> Reporting cycle end date. </summary>
        public DateTimeOffset? CycleEndOn { get; set; }
        /// <summary> Reporting cycle type. </summary>
        public DevTestLabReportingCycleType? CycleType { get; set; }
    }
}
