// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> The storage type for the disk (i.e. Standard, Premium). </summary>
    public readonly partial struct DevTestLabStorageType : IEquatable<DevTestLabStorageType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevTestLabStorageType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevTestLabStorageType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";
        private const string PremiumValue = "Premium";
        private const string StandardSsdValue = "StandardSSD";

        /// <summary> Standard. </summary>
        public static DevTestLabStorageType Standard { get; } = new DevTestLabStorageType(StandardValue);
        /// <summary> Premium. </summary>
        public static DevTestLabStorageType Premium { get; } = new DevTestLabStorageType(PremiumValue);
        /// <summary> StandardSSD. </summary>
        public static DevTestLabStorageType StandardSsd { get; } = new DevTestLabStorageType(StandardSsdValue);
        /// <summary> Determines if two <see cref="DevTestLabStorageType"/> values are the same. </summary>
        public static bool operator ==(DevTestLabStorageType left, DevTestLabStorageType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevTestLabStorageType"/> values are not the same. </summary>
        public static bool operator !=(DevTestLabStorageType left, DevTestLabStorageType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevTestLabStorageType"/>. </summary>
        public static implicit operator DevTestLabStorageType(string value) => new DevTestLabStorageType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevTestLabStorageType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevTestLabStorageType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
