// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> The artifact source's type. </summary>
    public readonly partial struct DevTestLabSourceControlType : IEquatable<DevTestLabSourceControlType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevTestLabSourceControlType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevTestLabSourceControlType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string VsoGitValue = "VsoGit";
        private const string GitHubValue = "GitHub";
        private const string StorageAccountValue = "StorageAccount";

        /// <summary> VsoGit. </summary>
        public static DevTestLabSourceControlType VsoGit { get; } = new DevTestLabSourceControlType(VsoGitValue);
        /// <summary> GitHub. </summary>
        public static DevTestLabSourceControlType GitHub { get; } = new DevTestLabSourceControlType(GitHubValue);
        /// <summary> StorageAccount. </summary>
        public static DevTestLabSourceControlType StorageAccount { get; } = new DevTestLabSourceControlType(StorageAccountValue);
        /// <summary> Determines if two <see cref="DevTestLabSourceControlType"/> values are the same. </summary>
        public static bool operator ==(DevTestLabSourceControlType left, DevTestLabSourceControlType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevTestLabSourceControlType"/> values are not the same. </summary>
        public static bool operator !=(DevTestLabSourceControlType left, DevTestLabSourceControlType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevTestLabSourceControlType"/>. </summary>
        public static implicit operator DevTestLabSourceControlType(string value) => new DevTestLabSourceControlType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevTestLabSourceControlType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevTestLabSourceControlType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
