// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Properties for creating a schedule. </summary>
    public partial class DevTestLabScheduleCreationParameter
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabScheduleCreationParameter"/>. </summary>
        public DevTestLabScheduleCreationParameter()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabScheduleCreationParameter"/>. </summary>
        /// <param name="name"> The name of the virtual machine or environment. </param>
        /// <param name="location"> The location of the new virtual machine or environment. </param>
        /// <param name="tags"> The tags of the resource. </param>
        /// <param name="status"> The status of the schedule (i.e. Enabled, Disabled). </param>
        /// <param name="taskType"> The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart). </param>
        /// <param name="weeklyRecurrence"> If the schedule will occur only some days of the week, specify the weekly recurrence. </param>
        /// <param name="dailyRecurrence"> If the schedule will occur once each day of the week, specify the daily recurrence. </param>
        /// <param name="hourlyRecurrence"> If the schedule will occur multiple times a day, specify the hourly recurrence. </param>
        /// <param name="timeZoneId"> The time zone ID (e.g. Pacific Standard time). </param>
        /// <param name="notificationSettings"> Notification settings. </param>
        /// <param name="targetResourceId"> The resource ID to which the schedule belongs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabScheduleCreationParameter(string name, AzureLocation? location, IDictionary<string, string> tags, DevTestLabEnableStatus? status, string taskType, DevTestLabWeekDetails weeklyRecurrence, DayDetails dailyRecurrence, HourDetails hourlyRecurrence, string timeZoneId, DevTestLabNotificationSettings notificationSettings, ResourceIdentifier targetResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Location = location;
            Tags = tags;
            Status = status;
            TaskType = taskType;
            WeeklyRecurrence = weeklyRecurrence;
            DailyRecurrence = dailyRecurrence;
            HourlyRecurrence = hourlyRecurrence;
            TimeZoneId = timeZoneId;
            NotificationSettings = notificationSettings;
            TargetResourceId = targetResourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the virtual machine or environment. </summary>
        public string Name { get; set; }
        /// <summary> The location of the new virtual machine or environment. </summary>
        public AzureLocation? Location { get; }
        /// <summary> The tags of the resource. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> The status of the schedule (i.e. Enabled, Disabled). </summary>
        public DevTestLabEnableStatus? Status { get; set; }
        /// <summary> The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart). </summary>
        public string TaskType { get; set; }
        /// <summary> If the schedule will occur only some days of the week, specify the weekly recurrence. </summary>
        public DevTestLabWeekDetails WeeklyRecurrence { get; set; }
        /// <summary> If the schedule will occur once each day of the week, specify the daily recurrence. </summary>
        internal DayDetails DailyRecurrence { get; set; }
        /// <summary> The time of day the schedule will occur. </summary>
        public string DailyRecurrenceTime
        {
            get => DailyRecurrence is null ? default : DailyRecurrence.Time;
            set
            {
                if (DailyRecurrence is null)
                    DailyRecurrence = new DayDetails();
                DailyRecurrence.Time = value;
            }
        }

        /// <summary> If the schedule will occur multiple times a day, specify the hourly recurrence. </summary>
        internal HourDetails HourlyRecurrence { get; set; }
        /// <summary> Minutes of the hour the schedule will run. </summary>
        public int? HourlyRecurrenceMinute
        {
            get => HourlyRecurrence is null ? default : HourlyRecurrence.Minute;
            set
            {
                if (HourlyRecurrence is null)
                    HourlyRecurrence = new HourDetails();
                HourlyRecurrence.Minute = value;
            }
        }

        /// <summary> The time zone ID (e.g. Pacific Standard time). </summary>
        public string TimeZoneId { get; set; }
        /// <summary> Notification settings. </summary>
        public DevTestLabNotificationSettings NotificationSettings { get; set; }
        /// <summary> The resource ID to which the schedule belongs. </summary>
        public ResourceIdentifier TargetResourceId { get; set; }
    }
}
