// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Reporting cycle type. </summary>
    public readonly partial struct DevTestLabReportingCycleType : IEquatable<DevTestLabReportingCycleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevTestLabReportingCycleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevTestLabReportingCycleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CalendarMonthValue = "CalendarMonth";
        private const string CustomValue = "Custom";

        /// <summary> CalendarMonth. </summary>
        public static DevTestLabReportingCycleType CalendarMonth { get; } = new DevTestLabReportingCycleType(CalendarMonthValue);
        /// <summary> Custom. </summary>
        public static DevTestLabReportingCycleType Custom { get; } = new DevTestLabReportingCycleType(CustomValue);
        /// <summary> Determines if two <see cref="DevTestLabReportingCycleType"/> values are the same. </summary>
        public static bool operator ==(DevTestLabReportingCycleType left, DevTestLabReportingCycleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevTestLabReportingCycleType"/> values are not the same. </summary>
        public static bool operator !=(DevTestLabReportingCycleType left, DevTestLabReportingCycleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevTestLabReportingCycleType"/>. </summary>
        public static implicit operator DevTestLabReportingCycleType(string value) => new DevTestLabReportingCycleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevTestLabReportingCycleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevTestLabReportingCycleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
