// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> The status of the policy. </summary>
    public readonly partial struct DevTestLabPolicyStatus : IEquatable<DevTestLabPolicyStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevTestLabPolicyStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevTestLabPolicyStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static DevTestLabPolicyStatus Enabled { get; } = new DevTestLabPolicyStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static DevTestLabPolicyStatus Disabled { get; } = new DevTestLabPolicyStatus(DisabledValue);
        /// <summary> Determines if two <see cref="DevTestLabPolicyStatus"/> values are the same. </summary>
        public static bool operator ==(DevTestLabPolicyStatus left, DevTestLabPolicyStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevTestLabPolicyStatus"/> values are not the same. </summary>
        public static bool operator !=(DevTestLabPolicyStatus left, DevTestLabPolicyStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevTestLabPolicyStatus"/>. </summary>
        public static implicit operator DevTestLabPolicyStatus(string value) => new DevTestLabPolicyStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevTestLabPolicyStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevTestLabPolicyStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
