// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Result of a policy set evaluation. </summary>
    public partial class DevTestLabPolicySetResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabPolicySetResult"/>. </summary>
        internal DevTestLabPolicySetResult()
        {
            PolicyViolations = new ChangeTrackingList<DevTestLabPolicyViolation>();
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabPolicySetResult"/>. </summary>
        /// <param name="hasError"> A value indicating whether this policy set evaluation has discovered violations. </param>
        /// <param name="policyViolations"> The list of policy violations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabPolicySetResult(bool? hasError, IReadOnlyList<DevTestLabPolicyViolation> policyViolations, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            HasError = hasError;
            PolicyViolations = policyViolations;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A value indicating whether this policy set evaluation has discovered violations. </summary>
        public bool? HasError { get; }
        /// <summary> The list of policy violations. </summary>
        public IReadOnlyList<DevTestLabPolicyViolation> PolicyViolations { get; }
    }
}
