// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc. </summary>
    public readonly partial struct DevTestLabPolicyFactName : IEquatable<DevTestLabPolicyFactName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevTestLabPolicyFactName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevTestLabPolicyFactName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UserOwnedLabVmCountValue = "UserOwnedLabVmCount";
        private const string UserOwnedLabPremiumVmCountValue = "UserOwnedLabPremiumVmCount";
        private const string LabVmCountValue = "LabVmCount";
        private const string LabPremiumVmCountValue = "LabPremiumVmCount";
        private const string LabVmSizeValue = "LabVmSize";
        private const string GalleryImageValue = "GalleryImage";
        private const string UserOwnedLabVmCountInSubnetValue = "UserOwnedLabVmCountInSubnet";
        private const string LabTargetCostValue = "LabTargetCost";
        private const string EnvironmentTemplateValue = "EnvironmentTemplate";
        private const string ScheduleEditPermissionValue = "ScheduleEditPermission";

        /// <summary> UserOwnedLabVmCount. </summary>
        public static DevTestLabPolicyFactName UserOwnedLabVmCount { get; } = new DevTestLabPolicyFactName(UserOwnedLabVmCountValue);
        /// <summary> UserOwnedLabPremiumVmCount. </summary>
        public static DevTestLabPolicyFactName UserOwnedLabPremiumVmCount { get; } = new DevTestLabPolicyFactName(UserOwnedLabPremiumVmCountValue);
        /// <summary> LabVmCount. </summary>
        public static DevTestLabPolicyFactName LabVmCount { get; } = new DevTestLabPolicyFactName(LabVmCountValue);
        /// <summary> LabPremiumVmCount. </summary>
        public static DevTestLabPolicyFactName LabPremiumVmCount { get; } = new DevTestLabPolicyFactName(LabPremiumVmCountValue);
        /// <summary> LabVmSize. </summary>
        public static DevTestLabPolicyFactName LabVmSize { get; } = new DevTestLabPolicyFactName(LabVmSizeValue);
        /// <summary> GalleryImage. </summary>
        public static DevTestLabPolicyFactName GalleryImage { get; } = new DevTestLabPolicyFactName(GalleryImageValue);
        /// <summary> UserOwnedLabVmCountInSubnet. </summary>
        public static DevTestLabPolicyFactName UserOwnedLabVmCountInSubnet { get; } = new DevTestLabPolicyFactName(UserOwnedLabVmCountInSubnetValue);
        /// <summary> LabTargetCost. </summary>
        public static DevTestLabPolicyFactName LabTargetCost { get; } = new DevTestLabPolicyFactName(LabTargetCostValue);
        /// <summary> EnvironmentTemplate. </summary>
        public static DevTestLabPolicyFactName EnvironmentTemplate { get; } = new DevTestLabPolicyFactName(EnvironmentTemplateValue);
        /// <summary> ScheduleEditPermission. </summary>
        public static DevTestLabPolicyFactName ScheduleEditPermission { get; } = new DevTestLabPolicyFactName(ScheduleEditPermissionValue);
        /// <summary> Determines if two <see cref="DevTestLabPolicyFactName"/> values are the same. </summary>
        public static bool operator ==(DevTestLabPolicyFactName left, DevTestLabPolicyFactName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevTestLabPolicyFactName"/> values are not the same. </summary>
        public static bool operator !=(DevTestLabPolicyFactName left, DevTestLabPolicyFactName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevTestLabPolicyFactName"/>. </summary>
        public static implicit operator DevTestLabPolicyFactName(string value) => new DevTestLabPolicyFactName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevTestLabPolicyFactName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevTestLabPolicyFactName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
