// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy). </summary>
    public readonly partial struct DevTestLabPolicyEvaluatorType : IEquatable<DevTestLabPolicyEvaluatorType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevTestLabPolicyEvaluatorType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevTestLabPolicyEvaluatorType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowedValuesPolicyValue = "AllowedValuesPolicy";
        private const string MaxValuePolicyValue = "MaxValuePolicy";

        /// <summary> AllowedValuesPolicy. </summary>
        public static DevTestLabPolicyEvaluatorType AllowedValuesPolicy { get; } = new DevTestLabPolicyEvaluatorType(AllowedValuesPolicyValue);
        /// <summary> MaxValuePolicy. </summary>
        public static DevTestLabPolicyEvaluatorType MaxValuePolicy { get; } = new DevTestLabPolicyEvaluatorType(MaxValuePolicyValue);
        /// <summary> Determines if two <see cref="DevTestLabPolicyEvaluatorType"/> values are the same. </summary>
        public static bool operator ==(DevTestLabPolicyEvaluatorType left, DevTestLabPolicyEvaluatorType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevTestLabPolicyEvaluatorType"/> values are not the same. </summary>
        public static bool operator !=(DevTestLabPolicyEvaluatorType left, DevTestLabPolicyEvaluatorType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevTestLabPolicyEvaluatorType"/>. </summary>
        public static implicit operator DevTestLabPolicyEvaluatorType(string value) => new DevTestLabPolicyEvaluatorType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevTestLabPolicyEvaluatorType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevTestLabPolicyEvaluatorType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
