// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> The event type for which this notification is enabled (i.e. AutoShutdown, Cost). </summary>
    public readonly partial struct DevTestLabNotificationChannelEventType : IEquatable<DevTestLabNotificationChannelEventType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevTestLabNotificationChannelEventType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevTestLabNotificationChannelEventType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutoShutdownValue = "AutoShutdown";
        private const string CostValue = "Cost";

        /// <summary> AutoShutdown. </summary>
        public static DevTestLabNotificationChannelEventType AutoShutdown { get; } = new DevTestLabNotificationChannelEventType(AutoShutdownValue);
        /// <summary> Cost. </summary>
        public static DevTestLabNotificationChannelEventType Cost { get; } = new DevTestLabNotificationChannelEventType(CostValue);
        /// <summary> Determines if two <see cref="DevTestLabNotificationChannelEventType"/> values are the same. </summary>
        public static bool operator ==(DevTestLabNotificationChannelEventType left, DevTestLabNotificationChannelEventType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevTestLabNotificationChannelEventType"/> values are not the same. </summary>
        public static bool operator !=(DevTestLabNotificationChannelEventType left, DevTestLabNotificationChannelEventType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevTestLabNotificationChannelEventType"/>. </summary>
        public static implicit operator DevTestLabNotificationChannelEventType(string value) => new DevTestLabNotificationChannelEventType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevTestLabNotificationChannelEventType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevTestLabNotificationChannelEventType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
