// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> A rule for NAT - exposing a VM's port (backendPort) on the public IP address using a load balancer. </summary>
    public partial class DevTestLabInboundNatRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabInboundNatRule"/>. </summary>
        public DevTestLabInboundNatRule()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabInboundNatRule"/>. </summary>
        /// <param name="transportProtocol"> The transport protocol for the endpoint. </param>
        /// <param name="frontendPort"> The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically. </param>
        /// <param name="backendPort"> The port to which the external traffic will be redirected. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabInboundNatRule(DevTestLabTransportProtocol? transportProtocol, int? frontendPort, int? backendPort, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TransportProtocol = transportProtocol;
            FrontendPort = frontendPort;
            BackendPort = backendPort;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The transport protocol for the endpoint. </summary>
        public DevTestLabTransportProtocol? TransportProtocol { get; set; }
        /// <summary> The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically. </summary>
        public int? FrontendPort { get; set; }
        /// <summary> The port to which the external traffic will be redirected. </summary>
        public int? BackendPort { get; set; }
    }
}
