// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> This represents the payload required to import a virtual machine from a different lab into the current one. </summary>
    public partial class DevTestLabImportVmContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabImportVmContent"/>. </summary>
        public DevTestLabImportVmContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabImportVmContent"/>. </summary>
        /// <param name="sourceVmResourceId"> The full resource ID of the virtual machine to be imported. </param>
        /// <param name="destinationVmName"> The name of the virtual machine in the destination lab. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabImportVmContent(ResourceIdentifier sourceVmResourceId, string destinationVmName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SourceVmResourceId = sourceVmResourceId;
            DestinationVmName = destinationVmName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The full resource ID of the virtual machine to be imported. </summary>
        public ResourceIdentifier SourceVmResourceId { get; set; }
        /// <summary> The name of the virtual machine in the destination lab. </summary>
        public string DestinationVmName { get; set; }
    }
}
