// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Caching option for a data disk (i.e. None, ReadOnly, ReadWrite). </summary>
    public readonly partial struct DevTestLabHostCachingOption : IEquatable<DevTestLabHostCachingOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevTestLabHostCachingOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevTestLabHostCachingOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ReadOnlyValue = "ReadOnly";
        private const string ReadWriteValue = "ReadWrite";

        /// <summary> None. </summary>
        public static DevTestLabHostCachingOption None { get; } = new DevTestLabHostCachingOption(NoneValue);
        /// <summary> ReadOnly. </summary>
        public static DevTestLabHostCachingOption ReadOnly { get; } = new DevTestLabHostCachingOption(ReadOnlyValue);
        /// <summary> ReadWrite. </summary>
        public static DevTestLabHostCachingOption ReadWrite { get; } = new DevTestLabHostCachingOption(ReadWriteValue);
        /// <summary> Determines if two <see cref="DevTestLabHostCachingOption"/> values are the same. </summary>
        public static bool operator ==(DevTestLabHostCachingOption left, DevTestLabHostCachingOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevTestLabHostCachingOption"/> values are not the same. </summary>
        public static bool operator !=(DevTestLabHostCachingOption left, DevTestLabHostCachingOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevTestLabHostCachingOption"/>. </summary>
        public static implicit operator DevTestLabHostCachingOption(string value) => new DevTestLabHostCachingOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevTestLabHostCachingOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevTestLabHostCachingOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
