// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> The parameters of the export operation. </summary>
    public partial class DevTestLabExportResourceUsageContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabExportResourceUsageContent"/>. </summary>
        public DevTestLabExportResourceUsageContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabExportResourceUsageContent"/>. </summary>
        /// <param name="blobStorageAbsoluteSasUri"> The blob storage absolute sas uri with write permission to the container which the usage data needs to be uploaded to. </param>
        /// <param name="usageStartOn"> The start time of the usage. If not provided, usage will be reported since the beginning of data collection. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabExportResourceUsageContent(Uri blobStorageAbsoluteSasUri, DateTimeOffset? usageStartOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BlobStorageAbsoluteSasUri = blobStorageAbsoluteSasUri;
            UsageStartOn = usageStartOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The blob storage absolute sas uri with write permission to the container which the usage data needs to be uploaded to. </summary>
        public Uri BlobStorageAbsoluteSasUri { get; set; }
        /// <summary> The start time of the usage. If not provided, usage will be reported since the beginning of data collection. </summary>
        public DateTimeOffset? UsageStartOn { get; set; }
    }
}
