// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    public partial class DevTestLabExportResourceUsageContent : IUtf8JsonSerializable, IJsonModel<DevTestLabExportResourceUsageContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DevTestLabExportResourceUsageContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DevTestLabExportResourceUsageContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevTestLabExportResourceUsageContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DevTestLabExportResourceUsageContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(BlobStorageAbsoluteSasUri))
            {
                writer.WritePropertyName("blobStorageAbsoluteSasUri"u8);
                writer.WriteStringValue(BlobStorageAbsoluteSasUri.AbsoluteUri);
            }
            if (Optional.IsDefined(UsageStartOn))
            {
                writer.WritePropertyName("usageStartDate"u8);
                writer.WriteStringValue(UsageStartOn.Value, "O");
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DevTestLabExportResourceUsageContent IJsonModel<DevTestLabExportResourceUsageContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevTestLabExportResourceUsageContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DevTestLabExportResourceUsageContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDevTestLabExportResourceUsageContent(document.RootElement, options);
        }

        internal static DevTestLabExportResourceUsageContent DeserializeDevTestLabExportResourceUsageContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Uri blobStorageAbsoluteSasUri = default;
            DateTimeOffset? usageStartDate = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("blobStorageAbsoluteSasUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    blobStorageAbsoluteSasUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("usageStartDate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    usageStartDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DevTestLabExportResourceUsageContent(blobStorageAbsoluteSasUri, usageStartDate, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DevTestLabExportResourceUsageContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevTestLabExportResourceUsageContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DevTestLabExportResourceUsageContent)} does not support writing '{options.Format}' format.");
            }
        }

        DevTestLabExportResourceUsageContent IPersistableModel<DevTestLabExportResourceUsageContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevTestLabExportResourceUsageContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDevTestLabExportResourceUsageContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DevTestLabExportResourceUsageContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DevTestLabExportResourceUsageContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
