// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Properties of an environment deployment. </summary>
    public partial class DevTestLabEnvironmentDeployment
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabEnvironmentDeployment"/>. </summary>
        public DevTestLabEnvironmentDeployment()
        {
            Parameters = new ChangeTrackingList<DevTestLabArmTemplateParameter>();
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabEnvironmentDeployment"/>. </summary>
        /// <param name="armTemplateId"> The Azure Resource Manager template's identifier. </param>
        /// <param name="parameters"> The parameters of the Azure Resource Manager template. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabEnvironmentDeployment(ResourceIdentifier armTemplateId, IList<DevTestLabArmTemplateParameter> parameters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ArmTemplateId = armTemplateId;
            Parameters = parameters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Azure Resource Manager template's identifier. </summary>
        public ResourceIdentifier ArmTemplateId { get; set; }
        /// <summary> The parameters of the Azure Resource Manager template. </summary>
        public IList<DevTestLabArmTemplateParameter> Parameters { get; }
    }
}
