// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Indicates if the artifact source is enabled (values: Enabled, Disabled). </summary>
    public readonly partial struct DevTestLabEnableStatus : IEquatable<DevTestLabEnableStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevTestLabEnableStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevTestLabEnableStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static DevTestLabEnableStatus Enabled { get; } = new DevTestLabEnableStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static DevTestLabEnableStatus Disabled { get; } = new DevTestLabEnableStatus(DisabledValue);
        /// <summary> Determines if two <see cref="DevTestLabEnableStatus"/> values are the same. </summary>
        public static bool operator ==(DevTestLabEnableStatus left, DevTestLabEnableStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevTestLabEnableStatus"/> values are not the same. </summary>
        public static bool operator !=(DevTestLabEnableStatus left, DevTestLabEnableStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevTestLabEnableStatus"/>. </summary>
        public static implicit operator DevTestLabEnableStatus(string value) => new DevTestLabEnableStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevTestLabEnableStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevTestLabEnableStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
