// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Properties for creating a custom image from a virtual machine. </summary>
    public partial class DevTestLabCustomImageVm
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabCustomImageVm"/>. </summary>
        public DevTestLabCustomImageVm()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabCustomImageVm"/>. </summary>
        /// <param name="sourceVmId"> The source vm identifier. </param>
        /// <param name="windowsOSInfo"> The Windows OS information of the VM. </param>
        /// <param name="linuxOSInfo"> The Linux OS information of the VM. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabCustomImageVm(string sourceVmId, WindowsOSInfo windowsOSInfo, LinuxOSInfo linuxOSInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SourceVmId = sourceVmId;
            WindowsOSInfo = windowsOSInfo;
            LinuxOSInfo = linuxOSInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The source vm identifier. </summary>
        public string SourceVmId { get; set; }
        /// <summary> The Windows OS information of the VM. </summary>
        internal WindowsOSInfo WindowsOSInfo { get; set; }
        /// <summary> The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied). </summary>
        public WindowsOSState? WindowsOSState
        {
            get => WindowsOSInfo is null ? default : WindowsOSInfo.WindowsOSState;
            set
            {
                if (WindowsOSInfo is null)
                    WindowsOSInfo = new WindowsOSInfo();
                WindowsOSInfo.WindowsOSState = value;
            }
        }

        /// <summary> The Linux OS information of the VM. </summary>
        internal LinuxOSInfo LinuxOSInfo { get; set; }
        /// <summary> The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied). </summary>
        public DevTestLabLinuxOSState? LinuxOSState
        {
            get => LinuxOSInfo is null ? default : LinuxOSInfo.LinuxOSState;
            set
            {
                if (LinuxOSInfo is null)
                    LinuxOSInfo = new LinuxOSInfo();
                LinuxOSInfo.LinuxOSState = value;
            }
        }
    }
}
