// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> The OS type of the custom image (i.e. Windows, Linux). </summary>
    public readonly partial struct DevTestLabCustomImageOSType : IEquatable<DevTestLabCustomImageOSType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevTestLabCustomImageOSType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevTestLabCustomImageOSType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WindowsValue = "Windows";
        private const string LinuxValue = "Linux";
        private const string NoneValue = "None";

        /// <summary> Windows. </summary>
        public static DevTestLabCustomImageOSType Windows { get; } = new DevTestLabCustomImageOSType(WindowsValue);
        /// <summary> Linux. </summary>
        public static DevTestLabCustomImageOSType Linux { get; } = new DevTestLabCustomImageOSType(LinuxValue);
        /// <summary> None. </summary>
        public static DevTestLabCustomImageOSType None { get; } = new DevTestLabCustomImageOSType(NoneValue);
        /// <summary> Determines if two <see cref="DevTestLabCustomImageOSType"/> values are the same. </summary>
        public static bool operator ==(DevTestLabCustomImageOSType left, DevTestLabCustomImageOSType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevTestLabCustomImageOSType"/> values are not the same. </summary>
        public static bool operator !=(DevTestLabCustomImageOSType left, DevTestLabCustomImageOSType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevTestLabCustomImageOSType"/>. </summary>
        public static implicit operator DevTestLabCustomImageOSType(string value) => new DevTestLabCustomImageOSType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevTestLabCustomImageOSType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevTestLabCustomImageOSType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
