// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> The type of the cost. </summary>
    public readonly partial struct DevTestLabCostType : IEquatable<DevTestLabCostType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevTestLabCostType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevTestLabCostType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnavailableValue = "Unavailable";
        private const string ReportedValue = "Reported";
        private const string ProjectedValue = "Projected";

        /// <summary> Unavailable. </summary>
        public static DevTestLabCostType Unavailable { get; } = new DevTestLabCostType(UnavailableValue);
        /// <summary> Reported. </summary>
        public static DevTestLabCostType Reported { get; } = new DevTestLabCostType(ReportedValue);
        /// <summary> Projected. </summary>
        public static DevTestLabCostType Projected { get; } = new DevTestLabCostType(ProjectedValue);
        /// <summary> Determines if two <see cref="DevTestLabCostType"/> values are the same. </summary>
        public static bool operator ==(DevTestLabCostType left, DevTestLabCostType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevTestLabCostType"/> values are not the same. </summary>
        public static bool operator !=(DevTestLabCostType left, DevTestLabCostType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevTestLabCostType"/>. </summary>
        public static implicit operator DevTestLabCostType(string value) => new DevTestLabCostType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevTestLabCostType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevTestLabCostType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
