// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Properties of a cost threshold item. </summary>
    public partial class DevTestLabCostThreshold
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabCostThreshold"/>. </summary>
        public DevTestLabCostThreshold()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabCostThreshold"/>. </summary>
        /// <param name="thresholdId"> The ID of the cost threshold item. </param>
        /// <param name="percentageThreshold"> The value of the percentage cost threshold. </param>
        /// <param name="displayOnChart"> Indicates whether this threshold will be displayed on cost charts. </param>
        /// <param name="sendNotificationWhenExceeded"> Indicates whether notifications will be sent when this threshold is exceeded. </param>
        /// <param name="notificationSent"> Indicates the datetime when notifications were last sent for this threshold. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabCostThreshold(string thresholdId, PercentageCostThresholdProperties percentageThreshold, DevTestLabCostThresholdStatus? displayOnChart, DevTestLabCostThresholdStatus? sendNotificationWhenExceeded, string notificationSent, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ThresholdId = thresholdId;
            PercentageThreshold = percentageThreshold;
            DisplayOnChart = displayOnChart;
            SendNotificationWhenExceeded = sendNotificationWhenExceeded;
            NotificationSent = notificationSent;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The ID of the cost threshold item. </summary>
        public string ThresholdId { get; set; }
        /// <summary> The value of the percentage cost threshold. </summary>
        internal PercentageCostThresholdProperties PercentageThreshold { get; set; }
        /// <summary> The cost threshold value. </summary>
        public double? ThresholdValue
        {
            get => PercentageThreshold is null ? default : PercentageThreshold.ThresholdValue;
            set
            {
                if (PercentageThreshold is null)
                    PercentageThreshold = new PercentageCostThresholdProperties();
                PercentageThreshold.ThresholdValue = value;
            }
        }

        /// <summary> Indicates whether this threshold will be displayed on cost charts. </summary>
        public DevTestLabCostThresholdStatus? DisplayOnChart { get; set; }
        /// <summary> Indicates whether notifications will be sent when this threshold is exceeded. </summary>
        public DevTestLabCostThresholdStatus? SendNotificationWhenExceeded { get; set; }
        /// <summary> Indicates the datetime when notifications were last sent for this threshold. </summary>
        public string NotificationSent { get; set; }
    }
}
