// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> The properties of a lab cost item. </summary>
    public partial class DevTestLabCostDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabCostDetails"/>. </summary>
        internal DevTestLabCostDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabCostDetails"/>. </summary>
        /// <param name="on"> The date of the cost item. </param>
        /// <param name="cost"> The cost component of the cost item. </param>
        /// <param name="costType"> The type of the cost. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabCostDetails(DateTimeOffset? @on, double? cost, DevTestLabCostType? costType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            On = @on;
            Cost = cost;
            CostType = costType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The date of the cost item. </summary>
        public DateTimeOffset? On { get; }
        /// <summary> The cost component of the cost item. </summary>
        public double? Cost { get; }
        /// <summary> The type of the cost. </summary>
        public DevTestLabCostType? CostType { get; }
    }
}
