// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Properties of an artifact. </summary>
    public partial class DevTestLabArtifactInstallInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabArtifactInstallInfo"/>. </summary>
        public DevTestLabArtifactInstallInfo()
        {
            Parameters = new ChangeTrackingList<DevTestLabArtifactParameter>();
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabArtifactInstallInfo"/>. </summary>
        /// <param name="artifactId"> The artifact's identifier. </param>
        /// <param name="artifactTitle"> The artifact's title. </param>
        /// <param name="parameters"> The parameters of the artifact. </param>
        /// <param name="status"> The status of the artifact. </param>
        /// <param name="deploymentStatusMessage"> The status message from the deployment. </param>
        /// <param name="vmExtensionStatusMessage"> The status message from the virtual machine extension. </param>
        /// <param name="installOn"> The time that the artifact starts to install on the virtual machine. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabArtifactInstallInfo(string artifactId, string artifactTitle, IList<DevTestLabArtifactParameter> parameters, string status, string deploymentStatusMessage, string vmExtensionStatusMessage, DateTimeOffset? installOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ArtifactId = artifactId;
            ArtifactTitle = artifactTitle;
            Parameters = parameters;
            Status = status;
            DeploymentStatusMessage = deploymentStatusMessage;
            VmExtensionStatusMessage = vmExtensionStatusMessage;
            InstallOn = installOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The artifact's identifier. </summary>
        public string ArtifactId { get; set; }
        /// <summary> The artifact's title. </summary>
        public string ArtifactTitle { get; set; }
        /// <summary> The parameters of the artifact. </summary>
        public IList<DevTestLabArtifactParameter> Parameters { get; }
        /// <summary> The status of the artifact. </summary>
        public string Status { get; set; }
        /// <summary> The status message from the deployment. </summary>
        public string DeploymentStatusMessage { get; set; }
        /// <summary> The status message from the virtual machine extension. </summary>
        public string VmExtensionStatusMessage { get; set; }
        /// <summary> The time that the artifact starts to install on the virtual machine. </summary>
        public DateTimeOffset? InstallOn { get; set; }
    }
}
