// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Parameters for generating an ARM template for deploying artifacts. </summary>
    public partial class DevTestLabArtifactGenerateArmTemplateContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabArtifactGenerateArmTemplateContent"/>. </summary>
        public DevTestLabArtifactGenerateArmTemplateContent()
        {
            Parameters = new ChangeTrackingList<DevTestLabParameter>();
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabArtifactGenerateArmTemplateContent"/>. </summary>
        /// <param name="vmName"> The resource name of the virtual machine. </param>
        /// <param name="parameters"> The parameters of the ARM template. </param>
        /// <param name="location"> The location of the virtual machine. </param>
        /// <param name="fileUploadOptions"> Options for uploading the files for the artifact. UploadFilesAndGenerateSasTokens is the default value. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabArtifactGenerateArmTemplateContent(string vmName, IList<DevTestLabParameter> parameters, AzureLocation? location, DevTestLabFileUploadOption? fileUploadOptions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VmName = vmName;
            Parameters = parameters;
            Location = location;
            FileUploadOptions = fileUploadOptions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The resource name of the virtual machine. </summary>
        public string VmName { get; set; }
        /// <summary> The parameters of the ARM template. </summary>
        public IList<DevTestLabParameter> Parameters { get; }
        /// <summary> The location of the virtual machine. </summary>
        public AzureLocation? Location { get; set; }
        /// <summary> Options for uploading the files for the artifact. UploadFilesAndGenerateSasTokens is the default value. </summary>
        public DevTestLabFileUploadOption? FileUploadOptions { get; set; }
    }
}
