// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Properties of an artifact deployment. </summary>
    public partial class DevTestLabArtifactDeploymentStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabArtifactDeploymentStatus"/>. </summary>
        internal DevTestLabArtifactDeploymentStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabArtifactDeploymentStatus"/>. </summary>
        /// <param name="deploymentStatus"> The deployment status of the artifact. </param>
        /// <param name="artifactsApplied"> The total count of the artifacts that were successfully applied. </param>
        /// <param name="totalArtifacts"> The total count of the artifacts that were tentatively applied. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabArtifactDeploymentStatus(string deploymentStatus, int? artifactsApplied, int? totalArtifacts, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DeploymentStatus = deploymentStatus;
            ArtifactsApplied = artifactsApplied;
            TotalArtifacts = totalArtifacts;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The deployment status of the artifact. </summary>
        public string DeploymentStatus { get; }
        /// <summary> The total count of the artifacts that were successfully applied. </summary>
        public int? ArtifactsApplied { get; }
        /// <summary> The total count of the artifacts that were tentatively applied. </summary>
        public int? TotalArtifacts { get; }
    }
}
