// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    public partial class DevTestLabArtifactDeploymentStatus : IUtf8JsonSerializable, IJsonModel<DevTestLabArtifactDeploymentStatus>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DevTestLabArtifactDeploymentStatus>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DevTestLabArtifactDeploymentStatus>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevTestLabArtifactDeploymentStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DevTestLabArtifactDeploymentStatus)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(DeploymentStatus))
            {
                writer.WritePropertyName("deploymentStatus"u8);
                writer.WriteStringValue(DeploymentStatus);
            }
            if (Optional.IsDefined(ArtifactsApplied))
            {
                writer.WritePropertyName("artifactsApplied"u8);
                writer.WriteNumberValue(ArtifactsApplied.Value);
            }
            if (Optional.IsDefined(TotalArtifacts))
            {
                writer.WritePropertyName("totalArtifacts"u8);
                writer.WriteNumberValue(TotalArtifacts.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DevTestLabArtifactDeploymentStatus IJsonModel<DevTestLabArtifactDeploymentStatus>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevTestLabArtifactDeploymentStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DevTestLabArtifactDeploymentStatus)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDevTestLabArtifactDeploymentStatus(document.RootElement, options);
        }

        internal static DevTestLabArtifactDeploymentStatus DeserializeDevTestLabArtifactDeploymentStatus(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string deploymentStatus = default;
            int? artifactsApplied = default;
            int? totalArtifacts = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("deploymentStatus"u8))
                {
                    deploymentStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("artifactsApplied"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    artifactsApplied = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalArtifacts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalArtifacts = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DevTestLabArtifactDeploymentStatus(deploymentStatus, artifactsApplied, totalArtifacts, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DevTestLabArtifactDeploymentStatus>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevTestLabArtifactDeploymentStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DevTestLabArtifactDeploymentStatus)} does not support writing '{options.Format}' format.");
            }
        }

        DevTestLabArtifactDeploymentStatus IPersistableModel<DevTestLabArtifactDeploymentStatus>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevTestLabArtifactDeploymentStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDevTestLabArtifactDeploymentStatus(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DevTestLabArtifactDeploymentStatus)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DevTestLabArtifactDeploymentStatus>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
