// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Status information about a virtual machine. </summary>
    public partial class ComputeVmInstanceViewStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ComputeVmInstanceViewStatus"/>. </summary>
        internal ComputeVmInstanceViewStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ComputeVmInstanceViewStatus"/>. </summary>
        /// <param name="code"> Gets the status Code. </param>
        /// <param name="displayStatus"> Gets the short localizable label for the status. </param>
        /// <param name="message"> Gets the message associated with the status. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ComputeVmInstanceViewStatus(string code, string displayStatus, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Code = code;
            DisplayStatus = displayStatus;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the status Code. </summary>
        public string Code { get; }
        /// <summary> Gets the short localizable label for the status. </summary>
        public string DisplayStatus { get; }
        /// <summary> Gets the message associated with the status. </summary>
        public string Message { get; }
    }
}
