// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> A data disks attached to a virtual machine. </summary>
    public partial class ComputeDataDisk
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ComputeDataDisk"/>. </summary>
        internal ComputeDataDisk()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ComputeDataDisk"/>. </summary>
        /// <param name="name"> Gets data disk name. </param>
        /// <param name="diskUri"> When backed by a blob, the URI of underlying blob. </param>
        /// <param name="managedDiskId"> When backed by managed disk, this is the ID of the compute disk resource. </param>
        /// <param name="diskSizeGiB"> Gets data disk size in GiB. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ComputeDataDisk(string name, Uri diskUri, string managedDiskId, int? diskSizeGiB, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            DiskUri = diskUri;
            ManagedDiskId = managedDiskId;
            DiskSizeGiB = diskSizeGiB;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets data disk name. </summary>
        public string Name { get; }
        /// <summary> When backed by a blob, the URI of underlying blob. </summary>
        public Uri DiskUri { get; }
        /// <summary> When backed by managed disk, this is the ID of the compute disk resource. </summary>
        public string ManagedDiskId { get; }
        /// <summary> Gets data disk size in GiB. </summary>
        public int? DiskSizeGiB { get; }
    }
}
